/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.authz.cover;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.AuthzPermissionException;
import org.sakaiproject.authz.api.GroupAlreadyDefinedException;
import org.sakaiproject.authz.api.GroupFullException;
import org.sakaiproject.authz.api.GroupIdInvalidException;
import org.sakaiproject.authz.api.GroupNotDefinedException;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.javax.PagingPosition;

public class AuthzGroupService {
    private static org.sakaiproject.authz.api.AuthzGroupService m_instance = null;
    public static String APPLICATION_ID = "sakai:authzGroup";
    public static String REFERENCE_ROOT = "/realm";
    public static String SECURE_ADD_AUTHZ_GROUP = "realm.add";
    public static String SECURE_REMOVE_AUTHZ_GROUP = "realm.del";
    public static String SECURE_UPDATE_AUTHZ_GROUP = "realm.upd";
    public static String SECURE_UPDATE_OWN_AUTHZ_GROUP = "realm.upd.own";
    public static String SECURE_VIEW_ALL_AUTHZ_GROUPS = "realm.view.all";
    public static String ANON_ROLE = ".anon";
    public static String AUTH_ROLE = ".auth";

    public static org.sakaiproject.authz.api.AuthzGroupService getInstance() {
        if (m_instance == null) {
            m_instance = (org.sakaiproject.authz.api.AuthzGroupService)ComponentManager.get(org.sakaiproject.authz.api.AuthzGroupService.class);
        }
        return m_instance;
    }

    public static List getAuthzGroups(String param0, PagingPosition param1) {
        org.sakaiproject.authz.api.AuthzGroupService service = AuthzGroupService.getInstance();
        if (service == null) {
            return null;
        }
        return service.getAuthzGroups(param0, param1);
    }

    public static List getAuthzUserGroupIds(ArrayList param0, String param1) {
        org.sakaiproject.authz.api.AuthzGroupService service = AuthzGroupService.getInstance();
        if (service == null) {
            return null;
        }
        return service.getAuthzUserGroupIds(param0, param1);
    }

    public static int countAuthzGroups(String param0) {
        org.sakaiproject.authz.api.AuthzGroupService service = AuthzGroupService.getInstance();
        if (service == null) {
            return 0;
        }
        return service.countAuthzGroups(param0);
    }

    public static Set getAuthzGroupIds(String providerId) {
        org.sakaiproject.authz.api.AuthzGroupService service = AuthzGroupService.getInstance();
        if (service == null) {
            return new HashSet();
        }
        return service.getAuthzGroupIds(providerId);
    }

    public Set getProviderIds(String authzGroupId) {
        org.sakaiproject.authz.api.AuthzGroupService service = AuthzGroupService.getInstance();
        if (service == null) {
            return new HashSet();
        }
        return service.getProviderIds(authzGroupId);
    }

    public static AuthzGroup getAuthzGroup(String param0) throws GroupNotDefinedException {
        org.sakaiproject.authz.api.AuthzGroupService service = AuthzGroupService.getInstance();
        if (service == null) {
            return null;
        }
        return service.getAuthzGroup(param0);
    }

    public static boolean allowUpdate(String param0) {
        org.sakaiproject.authz.api.AuthzGroupService service = AuthzGroupService.getInstance();
        if (service == null) {
            return false;
        }
        return service.allowUpdate(param0);
    }

    public static void save(AuthzGroup param0) throws GroupNotDefinedException, AuthzPermissionException {
        org.sakaiproject.authz.api.AuthzGroupService service = AuthzGroupService.getInstance();
        if (service == null) {
            return;
        }
        service.save(param0);
    }

    public static boolean allowAdd(String param0) {
        org.sakaiproject.authz.api.AuthzGroupService service = AuthzGroupService.getInstance();
        if (service == null) {
            return false;
        }
        return service.allowAdd(param0);
    }

    public static AuthzGroup addAuthzGroup(String param0) throws GroupIdInvalidException, GroupAlreadyDefinedException, AuthzPermissionException {
        org.sakaiproject.authz.api.AuthzGroupService service = AuthzGroupService.getInstance();
        if (service == null) {
            return null;
        }
        return service.addAuthzGroup(param0);
    }

    public static AuthzGroup addAuthzGroup(String param0, AuthzGroup param1, String param2) throws GroupIdInvalidException, GroupAlreadyDefinedException, AuthzPermissionException {
        org.sakaiproject.authz.api.AuthzGroupService service = AuthzGroupService.getInstance();
        if (service == null) {
            return null;
        }
        return service.addAuthzGroup(param0, param1, param2);
    }

    public static AuthzGroup newAuthzGroup(String param0, AuthzGroup param1, String param2) throws GroupAlreadyDefinedException {
        org.sakaiproject.authz.api.AuthzGroupService service = AuthzGroupService.getInstance();
        if (service == null) {
            return null;
        }
        return service.newAuthzGroup(param0, param1, param2);
    }

    public static boolean allowRemove(String param0) {
        org.sakaiproject.authz.api.AuthzGroupService service = AuthzGroupService.getInstance();
        if (service == null) {
            return false;
        }
        return service.allowRemove(param0);
    }

    public static void removeAuthzGroup(AuthzGroup param0) throws AuthzPermissionException {
        org.sakaiproject.authz.api.AuthzGroupService service = AuthzGroupService.getInstance();
        if (service == null) {
            return;
        }
        service.removeAuthzGroup(param0);
    }

    public static void removeAuthzGroup(String param0) throws AuthzPermissionException {
        org.sakaiproject.authz.api.AuthzGroupService service = AuthzGroupService.getInstance();
        if (service == null) {
            return;
        }
        service.removeAuthzGroup(param0);
    }

    public static String authzGroupReference(String param0) {
        org.sakaiproject.authz.api.AuthzGroupService service = AuthzGroupService.getInstance();
        if (service == null) {
            return null;
        }
        return service.authzGroupReference(param0);
    }

    public static void joinGroup(String param0, String param1) throws GroupNotDefinedException, AuthzPermissionException {
        org.sakaiproject.authz.api.AuthzGroupService service = AuthzGroupService.getInstance();
        if (service == null) {
            return;
        }
        service.joinGroup(param0, param1);
    }

    public static void joinGroup(String param0, String param1, int param2) throws GroupNotDefinedException, AuthzPermissionException, GroupFullException {
        org.sakaiproject.authz.api.AuthzGroupService service = AuthzGroupService.getInstance();
        if (service == null) {
            return;
        }
        service.joinGroup(param0, param1, param2);
    }

    public static void unjoinGroup(String param0) throws GroupNotDefinedException, AuthzPermissionException {
        org.sakaiproject.authz.api.AuthzGroupService service = AuthzGroupService.getInstance();
        if (service == null) {
            return;
        }
        service.unjoinGroup(param0);
    }

    public static boolean allowJoinGroup(String param0) {
        org.sakaiproject.authz.api.AuthzGroupService service = AuthzGroupService.getInstance();
        if (service == null) {
            return false;
        }
        return service.allowJoinGroup(param0);
    }

    public static boolean allowUnjoinGroup(String param0) {
        org.sakaiproject.authz.api.AuthzGroupService service = AuthzGroupService.getInstance();
        if (service == null) {
            return false;
        }
        return service.allowUnjoinGroup(param0);
    }

    public static Set getUsersIsAllowed(String param0, Collection param1) {
        org.sakaiproject.authz.api.AuthzGroupService service = AuthzGroupService.getInstance();
        if (service == null) {
            return null;
        }
        return service.getUsersIsAllowed(param0, param1);
    }

    public static Set<String[]> getUsersIsAllowedByGroup(String param0, Collection<String> param1) {
        org.sakaiproject.authz.api.AuthzGroupService service = AuthzGroupService.getInstance();
        if (service == null) {
            return null;
        }
        return service.getUsersIsAllowedByGroup(param0, param1);
    }

    public static Map<String, Integer> getUserCountIsAllowed(String param0, Collection<String> param1) {
        org.sakaiproject.authz.api.AuthzGroupService service = AuthzGroupService.getInstance();
        if (service == null) {
            return null;
        }
        return service.getUserCountIsAllowed(param0, param1);
    }

    public static Set getAuthzGroupsIsAllowed(String param0, String param1, Collection param2) {
        org.sakaiproject.authz.api.AuthzGroupService service = AuthzGroupService.getInstance();
        if (service == null) {
            return null;
        }
        return service.getAuthzGroupsIsAllowed(param0, param1, param2);
    }

    public static Set getAllowedFunctions(String param0, Collection param1) {
        org.sakaiproject.authz.api.AuthzGroupService service = AuthzGroupService.getInstance();
        if (service == null) {
            return null;
        }
        return service.getAllowedFunctions(param0, param1);
    }

    public static void refreshUser(String param0) {
        org.sakaiproject.authz.api.AuthzGroupService service = AuthzGroupService.getInstance();
        if (service == null) {
            return;
        }
        service.refreshUser(param0);
    }

    public static boolean isAllowed(String param0, String param1, Collection param2) {
        org.sakaiproject.authz.api.AuthzGroupService service = AuthzGroupService.getInstance();
        if (service == null) {
            return false;
        }
        return service.isAllowed(param0, param1, param2);
    }

    public static boolean isAllowed(String param0, String param1, String param2) {
        org.sakaiproject.authz.api.AuthzGroupService service = AuthzGroupService.getInstance();
        if (service == null) {
            return false;
        }
        return service.isAllowed(param0, param1, param2);
    }

    public static String getUserRole(String param0, String param1) {
        org.sakaiproject.authz.api.AuthzGroupService service = AuthzGroupService.getInstance();
        if (service == null) {
            return null;
        }
        return service.getUserRole(param0, param1);
    }

    public static Map<String, String> getUserRoles(String param0, Collection<String> param1) {
        org.sakaiproject.authz.api.AuthzGroupService service = AuthzGroupService.getInstance();
        if (service == null) {
            return null;
        }
        return service.getUserRoles(param0, param1);
    }

    public static Map getUsersRole(Collection param0, String param1) {
        org.sakaiproject.authz.api.AuthzGroupService service = AuthzGroupService.getInstance();
        if (service == null) {
            return null;
        }
        return service.getUsersRole(param0, param1);
    }

    public static Collection<String> getAuthzUsersInGroups(Set<String> groupIds) {
        org.sakaiproject.authz.api.AuthzGroupService service = AuthzGroupService.getInstance();
        if (service == null) {
            return null;
        }
        return service.getAuthzUsersInGroups(groupIds);
    }
}

