/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.dbcp.SakaiPoolableConnectionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericKeyedObjectPoolFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public class SakaiBasicDataSource
extends BasicDataSource {
    private static Log M_log = LogFactory.getLog(SakaiBasicDataSource.class);
    protected boolean m_rollbackOnReturn = false;

    public void setDefaultTransactionIsolationString(String defaultTransactionIsolation) {
        if (defaultTransactionIsolation == null || defaultTransactionIsolation.trim().length() == 0) {
            this.setDefaultTransactionIsolation(-1);
        } else if (defaultTransactionIsolation.trim().equalsIgnoreCase("TRANSACTION_NONE")) {
            this.setDefaultTransactionIsolation(0);
        } else if (defaultTransactionIsolation.trim().equalsIgnoreCase("TRANSACTION_READ_UNCOMMITTED")) {
            this.setDefaultTransactionIsolation(1);
        } else if (defaultTransactionIsolation.trim().equalsIgnoreCase("TRANSACTION_READ_COMMITTED")) {
            this.setDefaultTransactionIsolation(2);
        } else if (defaultTransactionIsolation.trim().equalsIgnoreCase("TRANSACTION_REPEATABLE_READ")) {
            this.setDefaultTransactionIsolation(4);
        } else if (defaultTransactionIsolation.trim().equalsIgnoreCase("TRANSACTION_SERIALIZABLE")) {
            this.setDefaultTransactionIsolation(8);
        } else {
            this.setDefaultTransactionIsolation(-1);
            M_log.warn((Object)("invalid transaction isolation level: " + defaultTransactionIsolation));
        }
    }

    public synchronized void setRollbackOnBorrow(boolean value) {
        this.m_rollbackOnReturn = value;
    }

    protected synchronized DataSource createDataSource() throws SQLException {
        if (this.dataSource != null) {
            return this.dataSource;
        }
        if (this.driverClassName != null) {
            try {
                Class.forName(this.driverClassName);
            }
            catch (Throwable t) {
                String message = "Cannot load JDBC driver class '" + this.driverClassName + "'";
                this.logWriter.println(message);
                t.printStackTrace(this.logWriter);
                throw new SQLNestedException(message, t);
            }
        }
        Driver driver = null;
        try {
            driver = DriverManager.getDriver(this.url);
        }
        catch (Throwable t) {
            String message = "Cannot create JDBC driver of class '" + (this.driverClassName != null ? this.driverClassName : "") + "' for connect URL '" + this.url + "'";
            this.logWriter.println(message);
            t.printStackTrace(this.logWriter);
            throw new SQLNestedException(message, t);
        }
        if (this.validationQuery == null) {
            this.setTestOnBorrow(false);
            this.setTestOnReturn(false);
            this.setTestWhileIdle(false);
        }
        this.connectionPool = new GenericObjectPool();
        this.connectionPool.setMaxActive(this.maxActive);
        this.connectionPool.setMaxIdle(this.maxIdle);
        this.connectionPool.setMinIdle(this.minIdle);
        this.connectionPool.setMaxWait(this.maxWait);
        this.connectionPool.setTestOnBorrow(this.testOnBorrow);
        this.connectionPool.setTestOnReturn(this.testOnReturn);
        this.connectionPool.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis);
        this.connectionPool.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun);
        this.connectionPool.setMinEvictableIdleTimeMillis(this.minEvictableIdleTimeMillis);
        this.connectionPool.setTestWhileIdle(this.testWhileIdle);
        GenericKeyedObjectPoolFactory statementPoolFactory = null;
        if (this.isPoolPreparedStatements()) {
            statementPoolFactory = new GenericKeyedObjectPoolFactory(null, -1, 0, 0L, 1, this.maxOpenPreparedStatements);
        }
        if (this.username != null) {
            this.connectionProperties.put("user", this.username);
        }
        if (this.password != null) {
            this.connectionProperties.put("password", this.password);
        }
        DriverConnectionFactory driverConnectionFactory = new DriverConnectionFactory(driver, this.url, this.connectionProperties);
        SakaiPoolableConnectionFactory connectionFactory = null;
        try {
            connectionFactory = new SakaiPoolableConnectionFactory((ConnectionFactory)driverConnectionFactory, (ObjectPool)this.connectionPool, (KeyedObjectPoolFactory)statementPoolFactory, this.validationQuery, this.defaultReadOnly, this.defaultAutoCommit, this.defaultTransactionIsolation, this.defaultCatalog, null, this.m_rollbackOnReturn);
            if (connectionFactory == null) {
                throw new SQLException("Cannot create PoolableConnectionFactory");
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLNestedException("Cannot create PoolableConnectionFactory (" + e.getMessage() + ")", (Throwable)e);
        }
        this.dataSource = new PoolingDataSource((ObjectPool)this.connectionPool);
        ((PoolingDataSource)this.dataSource).setAccessToUnderlyingConnectionAllowed(this.isAccessToUnderlyingConnectionAllowed());
        this.dataSource.setLogWriter(this.logWriter);
        try {
            for (int i = 0; i < this.initialSize; ++i) {
                this.connectionPool.addObject();
            }
        }
        catch (Exception e) {
            throw new SQLNestedException("Error preloading the connection pool", (Throwable)e);
        }
        return this.dataSource;
    }

    public void setConnectionProperties(String connectionProperties) {
        if (connectionProperties == null) {
            throw new NullPointerException("connectionProperties is null");
        }
        String[] entries = connectionProperties.split(";");
        Properties properties = new Properties();
        for (int i = 0; i < entries.length; ++i) {
            String entry = entries[i];
            if (entry.length() <= 0) continue;
            int index = entry.indexOf(61);
            if (index > 0) {
                String name = entry.substring(0, index);
                String value = entry.substring(index + 1);
                properties.setProperty(name, value);
                continue;
            }
            properties.setProperty(entry, "");
        }
        this.connectionProperties = properties;
    }
}

