/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.impl;

import java.io.File;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.component.impl.SpringCompMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

public class SakaiContextLoader
extends ContextLoader {
    private static final Logger log = LoggerFactory.getLogger(SakaiContextLoader.class);
    public static final String SPRING_CONTEXT_SUFFIX = "-context.xml";

    public WebApplicationContext initWebApplicationContext(ServletContext servletContext) throws BeansException {
        String servletName;
        String location;
        ConfigurableWebApplicationContext cwac = (ConfigurableWebApplicationContext)super.initWebApplicationContext(servletContext);
        if (cwac != null && StringUtils.isNotBlank((CharSequence)(location = this.getHomeBeanDefinitionIfExists(servletName = servletContext.getServletContextName())))) {
            log.debug("Servlet " + servletName + " is attempting to load bean definition [" + location + "]");
            XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)cwac.getBeanFactory());
            try {
                int loaded = reader.loadBeanDefinitions((Resource)new FileSystemResource(location));
                log.info("Servlet " + servletName + " loaded " + loaded + " beans from [" + location + "]");
                AnnotationConfigUtils.registerAnnotationConfigProcessors((BeanDefinitionRegistry)reader.getRegistry());
                cwac.getBeanFactory().preInstantiateSingletons();
            }
            catch (BeanDefinitionStoreException bdse) {
                log.warn("Failure loading beans from [" + location + "]", (Throwable)bdse);
            }
            catch (BeanCreationException bce) {
                log.warn("Failure instantiating beans from [" + location + "]", (Throwable)bce);
            }
        }
        return cwac;
    }

    protected ApplicationContext loadParentContext(ServletContext servletContext) throws BeansException {
        ConfigurableApplicationContext sharedAc = ((SpringCompMgr)ComponentManager.getInstance()).getApplicationContext();
        return sharedAc;
    }

    private String getHomeBeanDefinitionIfExists(String servletName) {
        if (StringUtils.isBlank((CharSequence)servletName)) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)servletName)) {
            String name = servletName + SPRING_CONTEXT_SUFFIX;
            String path = ServerConfigurationService.getSakaiHomePath();
            String location = path + name;
            log.debug("Servlet " + servletName + " is checking for a bean definition at sakai.home/" + name);
            if (new File(location).canRead()) {
                log.info("Servlet " + servletName + " located an additional bean definition at sakai.home/" + name);
                return location;
            }
            log.debug("Servlet " + servletName + " did not find a bean definition at sakai.home/" + name);
        }
        return null;
    }
}

