/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.impl;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.sakaiproject.component.api.ComponentManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockCompMgr
implements ComponentManager {
    private static Logger M_log = LoggerFactory.getLogger(MockCompMgr.class);
    public ConcurrentHashMap<String, Object> components = new ConcurrentHashMap();
    boolean closed = false;

    public MockCompMgr(boolean loadMocks) {
        M_log.warn("LOADING CM in testing mode... this should only ever happen during unit tests");
        if (loadMocks) {
            M_log.info("Created a populated CM mock with " + this.components.size() + " services loaded");
        } else {
            M_log.info("Created an empty CM mock (no services loaded)");
        }
    }

    @Override
    public void close() {
        this.components.clear();
        this.closed = true;
    }

    @Override
    public boolean hasBeenClosed() {
        return this.closed;
    }

    @Override
    public boolean contains(Class iface) {
        String key = iface != null ? iface.getName() : "";
        return this.components.contains(key);
    }

    @Override
    public boolean contains(String ifaceName) {
        String key = ifaceName != null ? ifaceName : "";
        return this.components.contains(key);
    }

    @Override
    public <T> T get(Class<T> iface) {
        String key = iface != null ? iface.getName() : "";
        return (T)this.components.get(key);
    }

    @Override
    public Object get(String ifaceName) {
        String key = ifaceName != null ? ifaceName : "";
        return this.components.get(key);
    }

    @Override
    public Properties getConfig() {
        return null;
    }

    @Override
    public Set<String> getRegisteredInterfaces() {
        return new HashSet<String>(this.components.keySet());
    }

    @Override
    public void loadComponent(Class iface, Object component) {
        if (iface == null) {
            throw new IllegalArgumentException("Failure while attempting to load component: iface is null");
        }
        if (component != null) {
            this.components.put(iface.getName(), component);
        } else {
            this.components.remove(iface.getName());
        }
    }

    @Override
    public void loadComponent(String ifaceName, Object component) {
        if (ifaceName == null) {
            throw new IllegalArgumentException("Failure while attempting to load component: ifaceName is null");
        }
        if (component != null) {
            this.components.put(ifaceName, component);
        } else {
            this.components.remove(ifaceName);
        }
    }

    @Override
    public void waitTillConfigured() {
    }
}

