/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.api;

import java.util.List;
import java.util.Locale;
import java.util.Map;

public interface ServerConfigurationService {
    public static final String SERVICE_NAME = ServerConfigurationService.class.getName();
    public static final String CURRENT_SERVER_URL = "sakai:request.server.url";
    public static final String CURRENT_PORTAL_PATH = "sakai:request.portal.path";
    public static final String UNKNOWN = "UNKNOWN";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_INT = "int";
    public static final String TYPE_ARRAY = "array";
    public static final String TYPE_STRING = "string";
    public static final String[] TYPES = new String[]{"boolean", "int", "array", "string", "UNKNOWN"};

    public String getServerId();

    public String getServerInstance();

    public String getServerIdInstance();

    public String getServerName();

    public String getServerUrl();

    public String getHelpUrl(String var1);

    public String getAccessUrl();

    public String getAccessPath();

    public String getPortalUrl();

    public String getToolUrl();

    public String getGatewaySiteId();

    public String getLoggedOutUrl();

    public String getUserHomeUrl();

    public String getSakaiHomePath();

    public String getString(String var1);

    public String getString(String var1, String var2);

    public String[] getStrings(String var1);

    public int getInt(String var1, int var2);

    public boolean getBoolean(String var1, boolean var2);

    public String getRawProperty(String var1);

    public List<String> getToolGroup(String var1);

    public List<String> getToolOrder(String var1);

    public boolean toolGroupIsSelected(String var1, String var2);

    public boolean toolGroupIsRequired(String var1, String var2);

    public List<String> getCategoryGroups(String var1);

    public List<String> getToolsRequired(String var1);

    public List<String> getDefaultTools(String var1);

    public List<String> getToolCategories(String var1);

    public Map<String, List<String>> getToolCategoriesAsMap(String var1);

    public Map<String, String> getToolToCategoryMap(String var1);

    public Locale[] getSakaiLocales();

    public Locale getLocaleFromString(String var1);

    public <T> T getConfig(String var1, T var2);

    public ConfigItem getConfigItem(String var1);

    public ConfigItem registerConfigItem(ConfigItem var1);

    public void registerListener(ConfigurationListener var1);

    public ConfigData getConfigData();

    public static interface ConfigurationListener {
        public ConfigItem changing(ConfigItem var1, ConfigItem var2);

        public void changed(ConfigItem var1, ConfigItem var2);

        public static class BlockingConfigItem
        implements ConfigItem {
            public static BlockingConfigItem instance() {
                return new BlockingConfigItem();
            }

            @Override
            public int requested() {
                return 0;
            }

            @Override
            public int changed(Object value, String source) {
                return 0;
            }

            @Override
            public ConfigItem copy() {
                return new BlockingConfigItem();
            }

            @Override
            public String getName() {
                return "BLOCKING";
            }

            @Override
            public Object getValue() {
                return null;
            }

            @Override
            public String getType() {
                return "BLOCKING";
            }

            @Override
            public String getDescription() {
                return null;
            }

            @Override
            public String getSource() {
                return null;
            }

            @Override
            public Object getDefaultValue() {
                return null;
            }

            @Override
            public int getRequested() {
                return 0;
            }

            @Override
            public int getChanged() {
                return 0;
            }

            @Override
            public int getVersion() {
                return 0;
            }

            @Override
            public ConfigHistory[] getHistory() {
                return null;
            }

            @Override
            public boolean isRegistered() {
                return false;
            }

            @Override
            public boolean isDefaulted() {
                return false;
            }

            @Override
            public boolean isSecured() {
                return false;
            }

            @Override
            public boolean isDynamic() {
                return false;
            }
        }
    }

    public static interface ConfigurationProvider {
        public List<ConfigItem> registerConfigItems(ConfigData var1);
    }

    public static interface ConfigHistory {
        public int getVersion();

        public long getTimestamp();

        public String getSource();

        public Object getValue();
    }

    public static interface ConfigItem {
        public int requested();

        public int changed(Object var1, String var2);

        public ConfigItem copy();

        public String getName();

        public Object getValue();

        public String getType();

        public String getSource();

        public Object getDefaultValue();

        public String getDescription();

        public int getRequested();

        public int getChanged();

        public int getVersion();

        public ConfigHistory[] getHistory();

        public boolean isRegistered();

        public boolean isDefaulted();

        public boolean isSecured();

        public boolean isDynamic();
    }

    public static interface ConfigData {
        public int getTotalConfigItems();

        public int getRegisteredConfigItems();

        public int getUnRegisteredConfigItems();

        public String[] getSources();

        public List<ConfigItem> getItems();
    }
}

