/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.impl;

import java.io.IOException;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.component.impl.SpringCompMgr;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;

public class ContextLoader
extends org.springframework.web.context.ContextLoader {
    private static Log M_log = LogFactory.getLog(ContextLoader.class);
    public static final String SHARED_LOCATION_PARAM = "contextSharedLocation";

    public WebApplicationContext initWebApplicationContext(ServletContext servletContext) throws BeansException {
        String[] locations;
        String sharedConfig;
        WebApplicationContext rv = super.initWebApplicationContext(servletContext);
        ConfigurableApplicationContext parent = (ConfigurableApplicationContext)rv.getParent();
        if (parent != null && (sharedConfig = servletContext.getInitParameter(SHARED_LOCATION_PARAM)) != null && (locations = StringUtils.tokenizeToStringArray((String)sharedConfig, (String)",; \t\n")) != null) {
            XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)parent.getBeanFactory());
            for (int i = 0; i < locations.length; ++i) {
                try {
                    reader.loadBeanDefinitions(rv.getResources(locations[i]));
                    continue;
                }
                catch (IOException e) {
                    M_log.warn((Object)("exception loading into parent: " + e));
                }
            }
        }
        return rv;
    }

    protected ApplicationContext loadParentContext(ServletContext servletContext) throws BeansException {
        ConfigurableApplicationContext sharedAc = ((SpringCompMgr)ComponentManager.getInstance()).getApplicationContext();
        return sharedAc;
    }
}

