/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import java.io.IOException;
import org.sakaiproject.util.BeanFactoryPostProcessorCreator;
import org.sakaiproject.util.NoisierDefaultListableBeanFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.ResourceEntityResolver;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ResourceLoader;
import org.xml.sax.EntityResolver;

public class SakaiApplicationContext
extends GenericApplicationContext {
    private String[] initialSingletonNames;
    private String[] configLocations;

    public SakaiApplicationContext() {
        super((DefaultListableBeanFactory)new NoisierDefaultListableBeanFactory());
    }

    protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        super.prepareBeanFactory(beanFactory);
        try {
            this.loadBeanDefinitions(beanFactory);
        }
        catch (IOException e) {
            throw new ApplicationContextException("I/O error parsing XML document for application context [" + this.getDisplayName() + "]", (Throwable)e);
        }
    }

    protected void loadBeanDefinitions(ConfigurableListableBeanFactory beanFactory) throws IOException {
        XmlBeanDefinitionReader beanDefinitionReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)beanFactory);
        beanDefinitionReader.setBeanClassLoader(Thread.currentThread().getContextClassLoader());
        beanDefinitionReader.setResourceLoader((ResourceLoader)this);
        beanDefinitionReader.setEntityResolver((EntityResolver)new ResourceEntityResolver((ResourceLoader)this));
        if (this.configLocations != null) {
            beanDefinitionReader.loadBeanDefinitions(this.configLocations);
        }
    }

    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        this.invokePostProcessorCreators(beanFactory);
        super.postProcessBeanFactory(beanFactory);
    }

    protected void onRefresh() throws BeansException {
        if (this.initialSingletonNames != null) {
            for (int i = 0; i < this.initialSingletonNames.length; ++i) {
                this.getBean(this.initialSingletonNames[i]);
            }
        }
        super.onRefresh();
    }

    public void invokePostProcessorCreators(ConfigurableListableBeanFactory beanFactory) {
        String[] postProcessorCreatorNames = beanFactory.getBeanNamesForType(BeanFactoryPostProcessorCreator.class, false, false);
        for (int i = 0; i < postProcessorCreatorNames.length; ++i) {
            BeanFactoryPostProcessorCreator postProcessorCreator = (BeanFactoryPostProcessorCreator)beanFactory.getBean(postProcessorCreatorNames[i]);
            for (BeanFactoryPostProcessor beanFactoryPostProcessor : postProcessorCreator.getBeanFactoryPostProcessors()) {
                this.addBeanFactoryPostProcessor(beanFactoryPostProcessor);
            }
        }
    }

    public void setInitialSingletonNames(String[] initialSingletonNames) {
        this.initialSingletonNames = initialSingletonNames;
    }

    public void setConfigLocations(String[] configLocations) {
        this.configLocations = configLocations;
    }
}

