/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.research.modules.common.util;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import org.sagebionetworks.research.domain.result.interfaces.AnswerResult;
import org.sagebionetworks.research.domain.result.interfaces.Result;
import org.sagebionetworks.research.domain.result.interfaces.TaskResult;
import org.threeten.bp.Instant;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.chrono.ChronoZonedDateTime;

public class FirstRunHelper {
    private FirstRunHelper() {
    }

    public static ZonedDateTime getLastRunDate(@NonNull TaskResult taskResult) {
        for (Result result : taskResult.getAsyncResults()) {
            Object answer;
            if (!result.getIdentifier().equals("lastRun") || !(result instanceof AnswerResult) || !((answer = ((AnswerResult)result).getAnswer()) instanceof ZonedDateTime)) continue;
            return (ZonedDateTime)answer;
        }
        return null;
    }

    public static boolean isFirstRun(@Nullable TaskResult result) {
        ZonedDateTime lastRunDate;
        if (result != null && result.getResult("infoTapped") == null && (lastRunDate = FirstRunHelper.getLastRunDate(result)) != null) {
            Instant taskStartInstant = result.getStartTime();
            ZonedDateTime taskStartDate = ZonedDateTime.ofInstant((Instant)taskStartInstant, (ZoneId)lastRunDate.getZone());
            return lastRunDate.isBefore((ChronoZonedDateTime)taskStartDate.minusMonths(1L));
        }
        return true;
    }
}

