/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.research.mobile_ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;
import butterknife.Optional;
import butterknife.Unbinder;
import org.sagebionetworks.research.mobile_ui.R;
import org.sagebionetworks.research.mobile_ui.widget.ActionButton;
import org.sagebionetworks.research.mobile_ui.widget.NavigationActionBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepHeader
extends ConstraintLayout {
    private static final Logger LOGGER = LoggerFactory.getLogger(StepHeader.class);
    @BindView(value=2131427463)
    @NonNull
    ConstraintLayout actionButtonGroup;
    @BindView(value=2131427468)
    @NonNull
    ActionButton cancelButton;
    @BindView(value=2131427470)
    @NonNull
    ActionButton infoButton;
    @BindView(value=2131427455)
    @NonNull
    ProgressBar progressBar;
    @BindView(value=2131427456)
    @NonNull
    ProgressBar progressBarFloating;
    @BindView(value=2131427457)
    @NonNull
    TextView progressLabel;
    @Nullable
    private NavigationActionBar.ActionButtonClickListener actionButtonClickListener;
    private boolean isCancelButtonHidden;
    private boolean isInfoButtonHidden;
    private boolean isProgressBarHidden;
    private boolean isProgressLabelHidden;
    @NonNull
    private Unbinder unbinder;
    private boolean usesFloatingProgressBar;

    public StepHeader(Context context) {
        super(context);
        this.commonInit(null);
    }

    public StepHeader(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.commonInit(attrs);
    }

    public StepHeader(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.commonInit(attrs);
    }

    @Optional
    @OnClick(value={2131427468, 2131427470})
    public void onActionButtonClick(@NonNull ActionButton actionButton) {
        LOGGER.debug("Action button clicked, text: {}", (Object)actionButton.getText());
        if (this.actionButtonClickListener != null) {
            this.actionButtonClickListener.onClick(actionButton);
        } else {
            LOGGER.debug("Action button clicked with null listener: {}", (Object)actionButton.getText());
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.unbinder.unbind();
    }

    public void onFinishInflate() {
        super.onFinishInflate();
        this.unbinder = ButterKnife.bind((View)this);
        this.layoutComponents();
    }

    public void setActionButtonClickListener(NavigationActionBar.ActionButtonClickListener listener) {
        this.actionButtonClickListener = listener;
    }

    protected void commonInit(@Nullable AttributeSet attrs) {
        this.getAttributes(attrs);
        StepHeader.inflate((Context)this.getContext(), (int)R.layout.rs2_step_header, (ViewGroup)this);
        this.onFinishInflate();
    }

    protected void getAttributes(@Nullable AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.StepHeader);
        this.isInfoButtonHidden = a.getBoolean(R.styleable.StepHeader_isInfoButtonHidden, false);
        this.isProgressBarHidden = a.getBoolean(R.styleable.StepHeader_isProgressBarHidden, false);
        this.isProgressLabelHidden = a.getBoolean(R.styleable.StepHeader_isProgressLabelHidden, false);
        this.isCancelButtonHidden = a.getBoolean(R.styleable.StepHeader_isCancelButtonHidden, false);
        this.usesFloatingProgressBar = a.getBoolean(R.styleable.StepHeader_usesFloatingProgressBar, false);
        a.recycle();
    }

    protected void layoutComponents() {
        if (this.isCancelButtonHidden) {
            this.cancelButton.setVisibility(8);
        }
        if (this.isInfoButtonHidden) {
            this.infoButton.setVisibility(8);
        }
        if (this.isProgressBarHidden) {
            this.progressBar.setVisibility(8);
            this.progressBarFloating.setVisibility(8);
        }
        if (this.isProgressLabelHidden) {
            this.progressLabel.setVisibility(8);
        }
        if (this.usesFloatingProgressBar) {
            this.progressBar.setVisibility(8);
            this.progressLabel.setVisibility(8);
        } else {
            this.progressBarFloating.setVisibility(8);
            if (this.isCancelButtonHidden && this.isInfoButtonHidden) {
                this.actionButtonGroup.setVisibility(8);
            }
        }
    }
}

