/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.research.mobile_ui.inject;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import dagger.MapKey;
import dagger.Module;
import dagger.Provides;
import dagger.multibindings.IntoMap;
import dagger.multibindings.Multibinds;
import java.util.Map;
import org.sagebionetworks.research.mobile_ui.show_step.view.FormUIStepFragment;
import org.sagebionetworks.research.mobile_ui.show_step.view.ShowActiveUIStepFragment;
import org.sagebionetworks.research.mobile_ui.show_step.view.ShowCountdownStepFragment;
import org.sagebionetworks.research.mobile_ui.show_step.view.ShowUIStepFragment;
import org.sagebionetworks.research.presentation.inject.DrawableModule;
import org.sagebionetworks.research.presentation.model.interfaces.StepView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Module(includes={DrawableModule.class})
public abstract class ShowStepModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShowStepModule.class);

    @Multibinds
    abstract Map<String, ShowStepFragmentFactory> fragmentFactoryMap();

    @Provides
    public static ShowStepFragmentFactory provideShowStepFragmentFactory(Map<String, ShowStepFragmentFactory> showStepFragmentFactoryMap) {
        return stepView -> {
            if (showStepFragmentFactoryMap.containsKey(stepView.getType())) {
                Fragment fragment = ((ShowStepFragmentFactory)showStepFragmentFactoryMap.get(stepView.getType())).create(stepView);
                LOGGER.debug("Created fragment with class: {} from stepView: {}", (Object)fragment.getClass().getCanonicalName(), (Object)stepView);
                if (fragment != null) {
                    return fragment;
                }
            }
            return ShowUIStepFragment.newInstance(stepView);
        };
    }

    @Provides
    @IntoMap
    @StepViewKey(value="active")
    static ShowStepFragmentFactory provideShowActiveUIStepFragmentFactory() {
        return ShowActiveUIStepFragment::newInstance;
    }

    @Provides
    @IntoMap
    @StepViewKey(value="ui")
    static ShowStepFragmentFactory provideShowUIStepFragmentFactory() {
        return ShowUIStepFragment::newInstance;
    }

    @Provides
    @IntoMap
    @StepViewKey(value="form")
    static ShowStepFragmentFactory provideFormUIStepFragmentFactory() {
        return FormUIStepFragment.Companion::newInstance;
    }

    @Provides
    @IntoMap
    @StepViewKey(value="countdown")
    static ShowStepFragmentFactory provideShowCountdownStepFragmentFactory() {
        return ShowCountdownStepFragment::newInstance;
    }

    public static interface ShowStepFragmentFactory {
        @NonNull
        public Fragment create(@NonNull StepView var1);
    }

    @MapKey
    public static @interface StepViewKey {
        public String value();
    }
}

