/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.research.mobile_ui.show_step.view.view_binding;

import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.Unbinder;
import org.sagebionetworks.research.mobile_ui.show_step.view.view_binding.StepViewBinding;
import org.sagebionetworks.research.mobile_ui.widget.ActionButton;
import org.sagebionetworks.research.mobile_ui.widget.NavigationActionBar;
import org.sagebionetworks.research.mobile_ui.widget.StepHeader;
import org.sagebionetworks.research.presentation.DisplayString;
import org.sagebionetworks.research.presentation.model.interfaces.UIStepView;

public class UIStepViewBinding<S extends UIStepView>
implements StepViewBinding<S> {
    private final UIStepViewHolder uiStepViewHolder = new UIStepViewHolder();
    private final Unbinder uiStepViewHolderUnbinder;

    public UIStepViewBinding(View view) {
        this.uiStepViewHolderUnbinder = ButterKnife.bind((Object)this.uiStepViewHolder, (View)view);
    }

    @Nullable
    public ActionButton getBackButton() {
        return this.uiStepViewHolder.backButton;
    }

    @Nullable
    public ActionButton getCancelButton() {
        return this.uiStepViewHolder.cancelButton;
    }

    @Nullable
    public TextView getDetail() {
        return this.uiStepViewHolder.detail;
    }

    @Nullable
    public TextView getFoonote() {
        return this.uiStepViewHolder.footnote;
    }

    @Nullable
    public ImageView getImageView() {
        return this.uiStepViewHolder.imageView;
    }

    @Nullable
    public ActionButton getInfoButton() {
        return this.uiStepViewHolder.infoButton;
    }

    @Nullable
    public NavigationActionBar getNavigationActionBar() {
        return this.uiStepViewHolder.navigationActionBar;
    }

    @Nullable
    public ActionButton getNextButton() {
        return this.uiStepViewHolder.nextButton;
    }

    @Nullable
    public ProgressBar getProgressBar() {
        return this.uiStepViewHolder.progressBar;
    }

    @Nullable
    public TextView getProgressLabel() {
        return this.uiStepViewHolder.progressLabel;
    }

    @NonNull
    public View getRootView() {
        return this.uiStepViewHolder.rootView;
    }

    @Nullable
    public ActionButton getSkipButton() {
        return this.uiStepViewHolder.skipButton;
    }

    @Nullable
    public View getStepBody() {
        return this.uiStepViewHolder.stepBody;
    }

    @Nullable
    public StepHeader getStepHeader() {
        return this.uiStepViewHolder.stepHeader;
    }

    @Nullable
    public TextView getText() {
        return this.uiStepViewHolder.text;
    }

    @Nullable
    public TextView getTitle() {
        return this.uiStepViewHolder.title;
    }

    @Override
    public void setActionButtonClickListener(NavigationActionBar.ActionButtonClickListener actionButtonClickListener) {
        StepHeader stepHeader;
        NavigationActionBar actionBar = this.getNavigationActionBar();
        if (actionBar != null) {
            actionBar.setActionButtonClickListener(actionButtonClickListener);
        }
        if ((stepHeader = this.getStepHeader()) != null) {
            stepHeader.setActionButtonClickListener(actionButtonClickListener);
        } else {
            ActionButton infoButton;
            ActionButton cancelButton = this.getCancelButton();
            if (cancelButton != null) {
                cancelButton.setOnClickListener(view -> actionButtonClickListener.onClick(cancelButton));
            }
            if ((infoButton = this.getInfoButton()) != null) {
                infoButton.setOnClickListener(view -> actionButtonClickListener.onClick(infoButton));
            }
        }
    }

    @Override
    public void unbind() {
        this.uiStepViewHolderUnbinder.unbind();
    }

    @Override
    public void update(S stepView) {
        this.updateTextView(this.getTitle(), stepView.getTitle());
        this.updateTextView(this.getText(), stepView.getText());
        this.updateTextView(this.getDetail(), stepView.getDetail());
        this.updateTextView(this.getFoonote(), stepView.getFootnote());
    }

    protected void updateTextView(TextView view, DisplayString displayString) {
        if (view != null) {
            if (displayString.getDisplayString() != null) {
                view.setText((CharSequence)displayString.getDisplayString());
            } else if (displayString.getDefaultDisplayStringRes() != null) {
                view.setText(displayString.getDefaultDisplayStringRes().intValue());
            } else {
                view.setText(null);
            }
        }
    }

    protected static class UIStepViewHolder {
        @BindView(value=2131427466)
        @Nullable
        public ActionButton backButton;
        @BindView(value=2131427468)
        @Nullable
        public ActionButton cancelButton;
        @BindView(value=2131427452)
        @Nullable
        public TextView detail;
        @BindView(value=2131427453)
        @Nullable
        public TextView footnote;
        @BindView(value=2131427454)
        @Nullable
        public ImageView imageView;
        @BindView(value=2131427470)
        @Nullable
        public ActionButton infoButton;
        @BindView(value=2131427467)
        @Nullable
        public NavigationActionBar navigationActionBar;
        @BindView(value=2131427469)
        @Nullable
        public ActionButton nextButton;
        @BindView(value=2131427455)
        @Nullable
        public ProgressBar progressBar;
        @BindView(value=2131427457)
        @Nullable
        public TextView progressLabel;
        @BindView(value=2131427461)
        @NonNull
        public View rootView;
        @BindView(value=2131427472)
        @Nullable
        public ActionButton skipButton;
        @BindView(value=2131427459)
        @Nullable
        public View stepBody;
        @BindView(value=2131427462)
        @Nullable
        public StepHeader stepHeader;
        @BindView(value=2131427477)
        @Nullable
        public TextView text;
        @BindView(value=2131427478)
        @Nullable
        public TextView title;

        protected UIStepViewHolder() {
        }
    }
}

