/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.research.mobile_ui.show_step.view;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelProviders;
import com.google.common.base.Preconditions;
import dagger.android.support.AndroidSupportInjection;
import java.io.Serializable;
import javax.inject.Inject;
import org.sagebionetworks.research.mobile_ui.R;
import org.sagebionetworks.research.mobile_ui.perform_task.PerformTaskFragment;
import org.sagebionetworks.research.mobile_ui.show_step.view.view_binding.StepViewBinding;
import org.sagebionetworks.research.mobile_ui.widget.ActionButton;
import org.sagebionetworks.research.presentation.model.interfaces.StepView;
import org.sagebionetworks.research.presentation.perform_task.PerformTaskViewModel;
import org.sagebionetworks.research.presentation.show_step.show_step_view_model_factories.AbstractShowStepViewModelFactory;
import org.sagebionetworks.research.presentation.show_step.show_step_view_models.ShowStepViewModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ShowStepFragmentBase<StepT extends StepView, ViewModelT extends ShowStepViewModel<StepT>, StepViewBindingT extends StepViewBinding<StepT>>
extends Fragment {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShowStepFragmentBase.class);
    private static final String ARGUMENT_STEP_VIEW = "STEP_VIEW";
    @Inject
    protected AbstractShowStepViewModelFactory abstractShowStepViewModelFactory;
    @Inject
    protected PerformTaskFragment performTaskFragment;
    protected PerformTaskViewModel performTaskViewModel;
    protected ViewModelT showStepViewModel;
    protected StepT stepView;
    protected StepViewBindingT stepViewBinding;

    public static Bundle createArguments(@NonNull StepView stepView) {
        Preconditions.checkNotNull((Object)stepView);
        Bundle args = new Bundle();
        args.putSerializable(ARGUMENT_STEP_VIEW, (Serializable)stepView);
        return args;
    }

    public void onAttach(Context context) {
        AndroidSupportInjection.inject((Fragment)this);
        super.onAttach(context);
        this.performTaskViewModel = (PerformTaskViewModel)ViewModelProviders.of((Fragment)this.performTaskFragment).get(PerformTaskViewModel.class);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        StepView stepView = null;
        if (savedInstanceState == null) {
            Bundle arguments = this.getArguments();
            if (arguments != null) {
                stepView = (StepView)this.getArguments().getSerializable(ARGUMENT_STEP_VIEW);
            }
        } else {
            stepView = (StepView)savedInstanceState.getSerializable(ARGUMENT_STEP_VIEW);
        }
        this.stepView = stepView;
        Preconditions.checkState((stepView != null ? 1 : 0) != 0, (Object)"stepView cannot be null");
        this.showStepViewModel = (ShowStepViewModel)ViewModelProviders.of((Fragment)this, (ViewModelProvider.Factory)this.abstractShowStepViewModelFactory.create(this.performTaskViewModel, stepView)).get(stepView.getIdentifier(), this.abstractShowStepViewModelFactory.getViewModelClass(stepView));
    }

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(this.getLayoutId(), container, false);
        this.stepViewBinding = this.instantiateAndBindBinding(view);
        this.stepViewBinding.setActionButtonClickListener(this::handleActionButtonClick);
        this.showStepViewModel.getStepView().observe((LifecycleOwner)this, this::update);
        this.stepViewBinding.setActionButtonClickListener(this::handleActionButtonClick);
        return view;
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        outState.putSerializable(ARGUMENT_STEP_VIEW, this.stepView);
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.stepViewBinding.unbind();
    }

    @Nullable
    protected String getActionTypeFromActionButton(@NonNull ActionButton actionButton) {
        int actionButtonId = actionButton.getId();
        if (R.id.rs2_step_navigation_action_forward == actionButtonId) {
            return "goForward";
        }
        if (R.id.rs2_step_navigation_action_backward == actionButtonId) {
            return "goBackward";
        }
        if (R.id.rs2_step_navigation_action_skip == actionButtonId) {
            return "skip";
        }
        if (R.id.rs2_step_navigation_action_cancel == actionButtonId) {
            return "cancel";
        }
        if (R.id.rs2_step_navigation_action_info == actionButtonId) {
            return "learnMore";
        }
        return null;
    }

    @LayoutRes
    protected abstract int getLayoutId();

    protected void handleActionButtonClick(@NonNull ActionButton actionButton) {
        String actionType = this.getActionTypeFromActionButton(actionButton);
        if (actionType.equals("cancel")) {
            boolean showDialog = false;
            if (this.performTaskViewModel.hasPreviousStep()) {
                showDialog = true;
            }
            this.performTaskFragment.cancelTask(showDialog);
        } else {
            this.showStepViewModel.handleAction(actionType);
        }
    }

    @NonNull
    protected abstract StepViewBindingT instantiateAndBindBinding(View var1);

    protected void update(StepT stepView) {
        this.stepViewBinding.update(stepView);
    }
}

