/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.research.mobile_ui.widget;

import android.animation.TimeInterpolator;
import android.app.Fragment;
import android.content.Context;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import org.sagebionetworks.research.mobile_ui.R;

public class StepSwitcher
extends FrameLayout {
    public static final DecelerateInterpolator interpolator = new DecelerateInterpolator(2.0f);
    private int animationTime;

    public StepSwitcher(Context context) {
        super(context);
        this.init();
    }

    public StepSwitcher(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public StepSwitcher(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public CharSequence getAccessibilityClassName() {
        return StepSwitcher.class.getName();
    }

    public void show(@NonNull View newStep, int direction) {
        this.show(newStep, direction, false);
    }

    public void show(@NonNull View newStep, int direction, boolean alwaysReplaceView) {
        String stepLayoutId;
        String currentStepId;
        View currentStep = this.findViewById(R.id.rs2_current_step);
        if (currentStep != null && (currentStepId = (String)currentStep.getTag(R.id.rs2_step_id)).equals(stepLayoutId = (String)newStep.getTag(R.id.rs2_step_id)) && !alwaysReplaceView) {
            return;
        }
        if (direction != 1 && direction != -1) {
            throw new IllegalArgumentException("NavDirection with value: " + direction + " is not supported.");
        }
        this.post(() -> {
            int currentIndex = 0;
            if (currentStep != null) {
                currentStep.setId(0);
                currentIndex = this.indexOfChild(currentStep);
            }
            FrameLayout.LayoutParams lp = this.getLayoutParams(newStep);
            this.addView(newStep, currentIndex, (ViewGroup.LayoutParams)lp);
            newStep.setId(R.id.rs2_current_step);
            if (currentStep != null) {
                int newTranslationX = direction * this.getWidth();
                newStep.setTranslationX((float)newTranslationX);
                newStep.animate().setDuration((long)this.animationTime).setInterpolator((TimeInterpolator)interpolator).translationX(0.0f);
                currentStep.animate().setInterpolator((TimeInterpolator)interpolator).setDuration((long)this.animationTime).translationX((float)(-1 * newTranslationX)).withEndAction(() -> this.removeView(currentStep));
            }
        });
    }

    public void show(@NonNull Fragment newStep, int direction) {
    }

    private FrameLayout.LayoutParams getLayoutParams(View stepView) {
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)stepView.getLayoutParams();
        if (lp == null) {
            lp = new FrameLayout.LayoutParams(-1, -1);
        }
        return lp;
    }

    private void init() {
        this.animationTime = this.getResources().getInteger(R.integer.rs2_step_horizontal_slide_anim_duration_ms);
    }
}

