/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.research.mobile_ui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.constraint.ConstraintLayout;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;
import butterknife.Optional;
import butterknife.Unbinder;
import org.sagebionetworks.research.mobile_ui.R;
import org.sagebionetworks.research.mobile_ui.widget.ActionButton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Keep
public class NavigationActionBar
extends ConstraintLayout {
    private static final Logger LOGGER = LoggerFactory.getLogger(NavigationActionBar.class);
    @BindView(value=2131427470)
    @NonNull
    ActionButton backwardButton;
    @BindView(value=2131427473)
    @NonNull
    ActionButton forwardButton;
    @BindView(value=2131427477)
    @NonNull
    ConstraintLayout primaryButtonGroup;
    @BindView(value=2131427478)
    @NonNull
    View shadowView;
    @BindView(value=2131427476)
    @NonNull
    ActionButton skipButton;
    private ActionButtonClickListener actionButtonClickListener;
    private boolean isBackwardHidden;
    private boolean isForwardHidden;
    private boolean isShadowHidden;
    private boolean isSkipHidden;
    private int primaryActionColor;
    private int primaryActionTitleColor;
    private int skipActionColor;
    @NonNull
    private Unbinder unbinder;

    public ActionButton getForwardButton() {
        return this.forwardButton;
    }

    public void setForwardButtonEnabled(boolean enabled) {
        this.forwardButton.setEnabled(enabled);
        if (enabled) {
            this.forwardButton.setAlpha(1.0f);
        } else {
            this.forwardButton.setAlpha(0.4f);
        }
    }

    @NonNull
    public ActionButton getSkipButton() {
        return this.skipButton;
    }

    public NavigationActionBar(Context context) {
        this(context, null);
        this.commonInit(null, 0);
    }

    public NavigationActionBar(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs, 0);
        this.commonInit(attrs, 0);
    }

    public NavigationActionBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.commonInit(attrs, defStyleAttr);
    }

    @Optional
    @OnClick(value={2131427470, 2131427473, 2131427476})
    public void onActionButtonClick(@NonNull ActionButton actionButton) {
        LOGGER.debug("Action button clicked, text: {}", (Object)actionButton.getText());
        if (this.actionButtonClickListener != null) {
            this.actionButtonClickListener.onClick(actionButton);
        } else {
            LOGGER.debug("Action button clicked with null listener: {}", (Object)actionButton.getText());
        }
    }

    public void setActionButtonClickListener(@NonNull ActionButtonClickListener actionButtonClickListener) {
        this.actionButtonClickListener = actionButtonClickListener;
    }

    protected void commonInit(@Nullable AttributeSet attrs, int defStyleAttr) {
        this.getAttributes(attrs, defStyleAttr);
        NavigationActionBar.inflate((Context)this.getContext(), (int)R.layout.rs2_navigation_action_bar, (ViewGroup)this);
        this.onFinishInflate();
    }

    protected void getAttributes(@Nullable AttributeSet attrs, int defStyleAttr) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.NavigationActionBar, defStyleAttr, 0);
        this.isForwardHidden = a.getBoolean(R.styleable.NavigationActionBar_isForwardHidden, false);
        this.isBackwardHidden = a.getBoolean(R.styleable.NavigationActionBar_isBackwardHidden, false);
        this.isShadowHidden = a.getBoolean(R.styleable.NavigationActionBar_isShadowHidden, false);
        this.isSkipHidden = a.getBoolean(R.styleable.NavigationActionBar_isSkipHidden, false);
        this.primaryActionColor = a.getColor(R.styleable.NavigationActionBar_primaryActionColor, 0);
        this.primaryActionTitleColor = a.getColor(R.styleable.NavigationActionBar_primaryActionTitleColor, 0);
        this.skipActionColor = a.getColor(R.styleable.NavigationActionBar_skipActionColor, 0);
        a.recycle();
    }

    protected void layoutComponents() {
        NavigationActionBar.hideComponentIfNecessary((View)this.forwardButton, this.isForwardHidden);
        NavigationActionBar.hideComponentIfNecessary((View)this.backwardButton, this.isBackwardHidden);
        NavigationActionBar.hideComponentIfNecessary((View)this.primaryButtonGroup, this.isForwardHidden && this.isBackwardHidden);
        NavigationActionBar.hideComponentIfNecessary((View)this.skipButton, this.isSkipHidden);
        NavigationActionBar.hideComponentIfNecessary(this.shadowView, this.isShadowHidden);
        if (this.primaryActionColor != 0) {
            this.forwardButton.getBackground().setColorFilter(this.primaryActionColor, PorterDuff.Mode.SRC_IN);
            this.backwardButton.getBackground().setColorFilter(this.primaryActionColor, PorterDuff.Mode.SRC_IN);
        }
        if (this.primaryActionTitleColor != 0) {
            this.forwardButton.setTextColor(this.primaryActionTitleColor);
            this.backwardButton.setTextColor(this.primaryActionTitleColor);
        }
        if (this.skipActionColor != 0) {
            this.skipButton.setTextColor(this.skipActionColor);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.unbinder.unbind();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.unbinder = ButterKnife.bind((View)this);
        this.layoutComponents();
    }

    private static void hideComponentIfNecessary(View component, boolean isHidden) {
        if (component != null && isHidden) {
            component.setVisibility(8);
        }
    }

    @Keep
    public static interface ActionButtonClickListener {
        public void onClick(ActionButton var1);
    }
}

