/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.research.mobile_ui.show_step.view;

import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.view.OnApplyWindowInsetsListener;
import android.support.v4.view.ViewCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import java.util.List;
import org.sagebionetworks.research.domain.result.implementations.NavigationResultBase;
import org.sagebionetworks.research.domain.result.interfaces.Result;
import org.sagebionetworks.research.domain.task.navigation.TaskProgress;
import org.sagebionetworks.research.mobile_ui.R;
import org.sagebionetworks.research.mobile_ui.show_step.view.ShowStepFragmentBase;
import org.sagebionetworks.research.mobile_ui.show_step.view.SystemWindowHelper;
import org.sagebionetworks.research.mobile_ui.show_step.view.view_binding.UIStepViewBinding;
import org.sagebionetworks.research.mobile_ui.widget.ActionButton;
import org.sagebionetworks.research.presentation.DisplayDrawable;
import org.sagebionetworks.research.presentation.DisplayString;
import org.sagebionetworks.research.presentation.model.AnimationImageThemeView;
import org.sagebionetworks.research.presentation.model.FetchableImageThemeView;
import org.sagebionetworks.research.presentation.model.ImageThemeView;
import org.sagebionetworks.research.presentation.model.action.ActionView;
import org.sagebionetworks.research.presentation.model.action.ActionViewBase;
import org.sagebionetworks.research.presentation.model.action.SkipToActionView;
import org.sagebionetworks.research.presentation.model.interfaces.UIStepView;
import org.sagebionetworks.research.presentation.show_step.show_step_view_models.ShowUIStepViewModel;
import org.threeten.bp.Instant;

public abstract class ShowUIStepFragmentBase<UIStepViewT extends UIStepView, VM extends ShowUIStepViewModel<UIStepViewT>, SB extends UIStepViewBinding<UIStepViewT>>
extends ShowStepFragmentBase<UIStepViewT, VM, SB> {
    protected ActionView getBackwardButtonActionView(UIStepView stepView) {
        ActionView result = this.getDefaultActionView(stepView, "goBackward");
        if (result != null) {
            return result;
        }
        if (this.performTaskViewModel.hasPreviousStep()) {
            String title = this.getResources().getString(R.string.rs2_navigation_action_backward);
            return ActionViewBase.builder().setButtonTitle(DisplayString.create(null, (String)title)).build();
        }
        return null;
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        ActionButton infoButton;
        View result = super.onCreateView(inflater, container, savedInstanceState);
        ActionButton cancelButton = ((UIStepViewBinding)this.stepViewBinding).getCancelButton();
        OnApplyWindowInsetsListener topInsetListener = SystemWindowHelper.getOnApplyWindowInsetsListener(SystemWindowHelper.Direction.TOP);
        if (cancelButton != null) {
            ViewCompat.setOnApplyWindowInsetsListener((View)cancelButton, (OnApplyWindowInsetsListener)topInsetListener);
        }
        if ((infoButton = ((UIStepViewBinding)this.stepViewBinding).getInfoButton()) != null) {
            ViewCompat.setOnApplyWindowInsetsListener((View)infoButton, (OnApplyWindowInsetsListener)topInsetListener);
        }
        return result;
    }

    public void onStart() {
        super.onStart();
        ViewCompat.requestApplyInsets((View)this.getView());
    }

    protected ActionView getCancelButtonActionView(UIStepView stepView) {
        ActionView result = this.getDefaultActionView(stepView, "cancel");
        if (result != null) {
            return result;
        }
        Integer iconResId = R.drawable.rs2_cancel_icon;
        return ActionViewBase.builder().setButtonIcon(DisplayDrawable.create(null, (Integer)iconResId)).build();
    }

    protected ActionView getDefaultActionView(UIStepView stepView, String actionType) {
        ActionView result = stepView.getActionFor(actionType);
        if (result != null) {
            return result;
        }
        result = this.performTaskViewModel.getActionFor(actionType);
        if (result != null) {
            return result;
        }
        return null;
    }

    protected ActionView getForwardButtonActionView(UIStepView stepView) {
        ActionView result = this.getDefaultActionView(stepView, "goForward");
        if (result != null) {
            return result;
        }
        String title = this.performTaskViewModel.hasNextStep() ? this.getResources().getString(R.string.rs2_navigation_action_forward) : this.getResources().getString(R.string.rs2_navigation_action_forward_last_step);
        return ActionViewBase.builder().setButtonTitle(DisplayString.create(null, (String)title)).build();
    }

    protected ActionView getInfoButtonActionView(UIStepView stepView) {
        ActionView result = this.getDefaultActionView(stepView, "learnMore");
        if (result != null) {
            return result;
        }
        Integer iconResId = R.drawable.rs2_info_icon;
        return ActionViewBase.builder().setButtonIcon(DisplayDrawable.create(null, (Integer)iconResId)).build();
    }

    protected ActionView getSkipButtonActionView(UIStepView stepView) {
        ActionView result = this.getDefaultActionView(stepView, "skip");
        if (result != null) {
            return result;
        }
        String title = this.getResources().getString(R.string.rs2_navigation_action_skip);
        return ActionViewBase.builder().setButtonTitle(DisplayString.create(null, (String)title)).build();
    }

    @Override
    protected void handleActionButtonClick(@NonNull ActionButton actionButton) {
        String actionType = this.getActionTypeFromActionButton(actionButton);
        ActionView actionView = ((UIStepView)this.stepView).getActionFor(actionType);
        if (actionView instanceof SkipToActionView) {
            this.handleSkipToStepAction((SkipToActionView)actionView);
        } else {
            super.handleActionButtonClick(actionButton);
        }
    }

    @Override
    protected void update(UIStepViewT stepView) {
        ImageThemeView imageTheme;
        ImageView imageView;
        super.update(stepView);
        this.updateNavigationButtons((UIStepView)stepView);
        TaskProgress progress = (TaskProgress)this.performTaskViewModel.getTaskProgress().getValue();
        if (progress != null) {
            TextView progressLabel;
            ProgressBar progressBar = ((UIStepViewBinding)this.stepViewBinding).getProgressBar();
            if (progressBar != null) {
                progressBar.setMax(progress.getTotal());
                progressBar.setProgress(progress.getProgress());
            }
            if ((progressLabel = ((UIStepViewBinding)this.stepViewBinding).getProgressLabel()) != null) {
                String progressString = "STEP " + progress.getProgress() + " OF " + progress.getTotal();
                progressLabel.setText((CharSequence)progressString);
            }
        }
        if ((imageView = ((UIStepViewBinding)this.stepViewBinding).getImageView()) != null && (imageTheme = stepView.getImageTheme()) != null) {
            DisplayDrawable drawable2;
            if (imageTheme instanceof AnimationImageThemeView) {
                AnimationImageThemeView animationImageTheme = (AnimationImageThemeView)imageTheme;
                List drawables = animationImageTheme.getImageResources();
                int duration = (int)(animationImageTheme.getDuration() * 1000.0 / (double)drawables.size());
                AnimationDrawable animation = new AnimationDrawable();
                for (DisplayDrawable displayDrawable : drawables) {
                    Drawable drawable3;
                    Integer drawableRes = displayDrawable.getDrawable();
                    if (drawableRes == null || (drawable3 = this.getResources().getDrawable(drawableRes.intValue())) == null) continue;
                    animation.addFrame(drawable3, duration);
                }
                imageView.setImageDrawable((Drawable)animation);
                animation.start();
            } else if (imageTheme instanceof FetchableImageThemeView && (drawable2 = ((FetchableImageThemeView)imageTheme).getImageResource()) != null) {
                Integer imageResourceId = drawable2.getDrawable();
                if (imageResourceId != null) {
                    imageView.setImageResource(imageResourceId.intValue());
                } else {
                    System.err.println("DisplayDrawable has null drawableRes and null defaultDrawableRes");
                }
            }
        }
    }

    protected void updateButtonFromActionView(ActionButton button, ActionView actionView) {
        if (button != null) {
            if (actionView != null) {
                Integer drawable2;
                DisplayDrawable buttonIcon;
                String title;
                DisplayString buttonTitle = actionView.getButtonTitle();
                if (buttonTitle != null && (title = buttonTitle.getString(this.getContext().getResources())) != null) {
                    button.setText(title);
                }
                if ((buttonIcon = actionView.getButtonIcon()) != null && (drawable2 = buttonIcon.getDrawable()) != null) {
                    button.setBackgroundResource(drawable2);
                }
            } else {
                button.setVisibility(8);
            }
        }
    }

    protected void updateNavigationButtons(UIStepView stepView) {
        ActionButton forwardButton = ((UIStepViewBinding)this.stepViewBinding).getNextButton();
        ActionView forwardActionView = this.getForwardButtonActionView(stepView);
        this.updateButtonFromActionView(forwardButton, forwardActionView);
        ActionButton backButton = ((UIStepViewBinding)this.stepViewBinding).getBackButton();
        ActionView backActionView = this.getBackwardButtonActionView(stepView);
        this.updateButtonFromActionView(backButton, backActionView);
        ActionButton cancelButton = ((UIStepViewBinding)this.stepViewBinding).getCancelButton();
        ActionView cancelActionView = this.getCancelButtonActionView(stepView);
        this.updateButtonFromActionView(cancelButton, cancelActionView);
        ActionButton skipButton = ((UIStepViewBinding)this.stepViewBinding).getSkipButton();
        ActionView skipActionView = this.getSkipButtonActionView(stepView);
        this.updateButtonFromActionView(skipButton, skipActionView);
        ActionButton infoButton = ((UIStepViewBinding)this.stepViewBinding).getInfoButton();
        ActionView infoActionView = this.getInfoButtonActionView(stepView);
        this.updateButtonFromActionView(infoButton, infoActionView);
    }

    protected void handleSkipToStepAction(SkipToActionView actionView) {
        String skipToStepId = actionView.getSkipToIdentifier();
        NavigationResultBase navigationResult = new NavigationResultBase(((UIStepView)this.stepView).getIdentifier(), Instant.now(), Instant.now(), skipToStepId);
        this.performTaskViewModel.addStepResult((Result)navigationResult);
        ((ShowUIStepViewModel)this.showStepViewModel).handleAction("goForward");
    }
}

