/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.research.mobile_ui.perform_task;

import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.ViewModelProvider;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.AlertDialog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import butterknife.ButterKnife;
import butterknife.Unbinder;
import com.google.common.base.Preconditions;
import dagger.android.AndroidInjector;
import dagger.android.DispatchingAndroidInjector;
import dagger.android.support.AndroidSupportInjection;
import dagger.android.support.HasSupportFragmentInjector;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.sagebionetworks.research.domain.result.implementations.TaskResultBase;
import org.sagebionetworks.research.domain.result.interfaces.TaskResult;
import org.sagebionetworks.research.mobile_ui.R;
import org.sagebionetworks.research.mobile_ui.inject.ShowStepModule;
import org.sagebionetworks.research.presentation.model.TaskView;
import org.sagebionetworks.research.presentation.model.interfaces.StepView;
import org.sagebionetworks.research.presentation.perform_task.PerformTaskViewModel;
import org.sagebionetworks.research.presentation.perform_task.PerformTaskViewModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.Instant;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.zone.ZoneRulesException;

public class PerformTaskFragment
extends Fragment
implements HasSupportFragmentInjector {
    private static final Logger LOGGER = LoggerFactory.getLogger(PerformTaskFragment.class);
    private static final String ARGUMENT_TASK_VIEW = "TASK_VIEW";
    private static final String ARGUMENT_TASK_RUN_UUID = "TASK_RUN_UUID";
    public static final String LAST_RUN_KEY = "LAST_RUN";
    public static final String RUN_COUNT_KEY = "RUN_COUNT";
    @Inject
    DispatchingAndroidInjector<Fragment> fragmentDispatchingAndroidInjector;
    @Inject
    ShowStepModule.ShowStepFragmentFactory showStepFragmentFactory;
    @Inject
    PerformTaskViewModelFactory taskViewModelFactory;
    private Fragment currentStepFragment;
    private PerformTaskViewModel performTaskViewModel;
    private AtomicBoolean showedStep = new AtomicBoolean();
    private ParcelUuid taskRunParcelableUuid;
    private TaskView taskView;
    private Unbinder unbinder;
    @Nullable
    private PerformTaskViewModelFactory.SharedPrefsArgs sharedPrefsArgs;

    public static PerformTaskFragment newInstance(@NonNull TaskView taskView, @Nullable UUID taskRunUUID) {
        Preconditions.checkNotNull((Object)taskView);
        Bundle arguments = new Bundle();
        arguments.putParcelable(ARGUMENT_TASK_VIEW, (Parcelable)taskView);
        if (taskRunUUID != null) {
            arguments.putParcelable(ARGUMENT_TASK_RUN_UUID, (Parcelable)new ParcelUuid(taskRunUUID));
        }
        PerformTaskFragment fragment = new PerformTaskFragment();
        fragment.setArguments(arguments);
        return fragment;
    }

    public void onAttach(Context context) {
        AndroidSupportInjection.inject((Fragment)this);
        super.onAttach(context);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState == null) {
            Bundle arguments = this.getArguments();
            if (arguments != null) {
                this.taskView = (TaskView)this.getArguments().getParcelable(ARGUMENT_TASK_VIEW);
                this.taskRunParcelableUuid = (ParcelUuid)this.getArguments().getParcelable(ARGUMENT_TASK_RUN_UUID);
            }
        } else {
            this.taskView = (TaskView)savedInstanceState.getParcelable(ARGUMENT_TASK_VIEW);
            this.taskRunParcelableUuid = (ParcelUuid)savedInstanceState.getParcelable(ARGUMENT_TASK_RUN_UUID);
        }
        Preconditions.checkState((this.taskView != null ? 1 : 0) != 0, (Object)"taskView cannot be null");
        LOGGER.debug("taskView: {}", (Object)this.taskView);
        if (this.taskRunParcelableUuid == null) {
            LOGGER.debug("No taskRunUUID found, generating random UUID");
            this.taskRunParcelableUuid = new ParcelUuid(UUID.randomUUID());
        }
        TaskResultBase taskResult = new TaskResultBase("taskID", Instant.now(), UUID.randomUUID());
        this.sharedPrefsArgs = this.getSharedPrefsArgs();
        this.performTaskViewModel = (PerformTaskViewModel)ViewModelProviders.of((Fragment)this, (ViewModelProvider.Factory)this.taskViewModelFactory.create(this.taskView, this.taskRunParcelableUuid.getUuid(), this.sharedPrefsArgs)).get(PerformTaskViewModel.class);
        this.performTaskViewModel.getStepView().observe((LifecycleOwner)this, this::showStep);
    }

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.rs2_fragment_perform_task, container, false);
        this.unbinder = ButterKnife.bind((Object)((Object)this), (View)view);
        return view;
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        outState.putParcelable(ARGUMENT_TASK_VIEW, (Parcelable)this.taskView);
        outState.putParcelable(ARGUMENT_TASK_RUN_UUID, (Parcelable)this.taskRunParcelableUuid);
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.unbinder.unbind();
    }

    public AndroidInjector<Fragment> supportFragmentInjector() {
        return this.fragmentDispatchingAndroidInjector;
    }

    public void cancelTask(boolean showDialog) {
        LOGGER.debug("Cancel button clicked");
        if (showDialog && this.getActivity() != null) {
            LOGGER.debug("Show the dialog here");
            new AlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.rs2_are_you_sure_cancel_task).setPositiveButton(R.string.rs2_are_you_sure_cancel_task_discard, (dialog, i) -> this.checkExitListener(OnPerformTaskExitListener.Status.CANCELLED)).setNegativeButton(R.string.rs2_are_you_sure_cancel_task_keep_going, null).create().show();
        } else {
            this.checkExitListener(OnPerformTaskExitListener.Status.CANCELLED);
        }
    }

    public void checkExitListener(OnPerformTaskExitListener.Status finishStatus) {
        OnPerformTaskExitListener onPerformTaskExitListener = null;
        if (this.getParentFragment() instanceof OnPerformTaskExitListener) {
            onPerformTaskExitListener = (OnPerformTaskExitListener)this.getParentFragment();
        }
        if (onPerformTaskExitListener == null && this.getActivity() instanceof OnPerformTaskExitListener) {
            onPerformTaskExitListener = (OnPerformTaskExitListener)this.getActivity();
        }
        if (onPerformTaskExitListener != null) {
            onPerformTaskExitListener.onTaskExit(finishStatus, this.performTaskViewModel.getTaskResult());
        }
    }

    void afterLastStep() {
        if (this.currentStepFragment != null) {
            this.getChildFragmentManager().beginTransaction().remove(this.currentStepFragment).commit();
            this.currentStepFragment = null;
        }
        String sharedPreferencesKey = this.taskView.getIdentifier();
        SharedPreferences sharedPreferences = this.getContext().getSharedPreferences(sharedPreferencesKey, 0);
        int runCount = 1;
        if (this.sharedPrefsArgs != null) {
            runCount = this.sharedPrefsArgs.runCount + 1;
        }
        sharedPreferences.edit().putLong(LAST_RUN_KEY, Instant.now().toEpochMilli()).putInt(RUN_COUNT_KEY, runCount).apply();
        this.checkExitListener(OnPerformTaskExitListener.Status.FINISHED);
    }

    @VisibleForTesting
    void showStep(@Nullable PerformTaskViewModel.StepViewNavigation stepViewNavigation) {
        Fragment step;
        StepView stepView = null;
        if (stepViewNavigation != null) {
            stepView = stepViewNavigation.getStepView();
        }
        if (stepView == null) {
            if (!this.showedStep.compareAndSet(false, true)) {
                this.afterLastStep();
            }
            return;
        }
        this.showedStep.set(true);
        this.currentStepFragment = step = this.showStepFragmentFactory.create(stepView);
        FragmentTransaction transaction = this.getChildFragmentManager().beginTransaction();
        int navDirection = stepViewNavigation.getNavDirection();
        if (1 == navDirection) {
            transaction.setCustomAnimations(R.anim.rs2_right_slide_in, R.anim.rs2_left_slide_out);
        } else if (-1 == navDirection) {
            transaction.setCustomAnimations(R.anim.rs2_left_slide_in, R.anim.rs2_right_slide_out);
        } else {
            LOGGER.error("Custom NavDirection " + navDirection + " not supported.  Shifting left by default.");
            transaction.setCustomAnimations(R.anim.rs2_right_slide_in, R.anim.rs2_left_slide_out);
        }
        transaction.replace(R.id.rs2_step_container, step, stepView.getIdentifier()).commit();
    }

    @Nullable
    private PerformTaskViewModelFactory.SharedPrefsArgs getSharedPrefsArgs() {
        ZoneId zoneId;
        String sharedPreferencesKey = this.taskView.getIdentifier();
        SharedPreferences sharedPreferences = this.getContext().getSharedPreferences(sharedPreferencesKey, 0);
        Long lastRun = sharedPreferences.getLong(LAST_RUN_KEY, 0L);
        if (lastRun == 0L) {
            return null;
        }
        Instant lastRunInstant = Instant.ofEpochMilli((long)lastRun);
        try {
            zoneId = ZoneId.systemDefault();
        }
        catch (ZoneRulesException e) {
            zoneId = ZoneId.of((String)"Z");
        }
        ZonedDateTime lastRunDateTime = ZonedDateTime.ofInstant((Instant)lastRunInstant, (ZoneId)zoneId);
        int runCount = sharedPreferences.getInt(RUN_COUNT_KEY, 1);
        return new PerformTaskViewModelFactory.SharedPrefsArgs(lastRunDateTime, runCount);
    }

    public void goForward() {
        this.performTaskViewModel.goForward();
    }

    public void goBackwards() {
        this.performTaskViewModel.goBack();
    }

    public static interface OnPerformTaskExitListener {
        public void onTaskExit(@NonNull Status var1, @NonNull TaskResult var2);

        public static enum Status {
            CANCELLED,
            FINISHED;

        }
    }
}

