/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.research.mobile_ui.show_step.view;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.Observer;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.ProgressBar;
import android.widget.TextView;
import java.util.Locale;
import org.sagebionetworks.research.mobile_ui.show_step.view.ShowUIStepFragmentBase;
import org.sagebionetworks.research.mobile_ui.show_step.view.view_binding.ActiveUIStepViewBinding;
import org.sagebionetworks.research.presentation.model.interfaces.ActiveUIStepView;
import org.sagebionetworks.research.presentation.show_step.show_step_view_models.ShowActiveUIStepViewModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ShowActiveUIStepFragmentBase<S extends ActiveUIStepView, VM extends ShowActiveUIStepViewModel<S>, SB extends ActiveUIStepViewBinding<S>>
extends ShowUIStepFragmentBase<S, VM, SB> {
    public static final Logger LOGGER = LoggerFactory.getLogger(ShowActiveUIStepFragmentBase.class);
    public static final int PROGRESS_BAR_ANIMATION_MULTIPLIER = 100;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup viewGroup, Bundle savedInstanceState) {
        Observer<Long> countdownObserver;
        TextView countLabel;
        View result = super.onCreateView(inflater, viewGroup, savedInstanceState);
        Long duration = ((ActiveUIStepView)this.stepView).getDuration().getSeconds();
        ProgressBar countdownDial = ((ActiveUIStepViewBinding)this.stepViewBinding).getCountdownDial();
        if (countdownDial != null) {
            countdownDial.setProgress(0);
            countdownDial.setMax(duration.intValue() * 100);
        }
        if ((countLabel = ((ActiveUIStepViewBinding)this.stepViewBinding).getCountLabel()) != null) {
            countLabel.setText((CharSequence)String.format(duration.toString(), Locale.getDefault()));
        }
        if ((countdownObserver = this.getCountdownObserver()) != null) {
            LiveData countdown = ((ShowActiveUIStepViewModel)this.showStepViewModel).getCountdown();
            countdown.observe((LifecycleOwner)this, this.getCountdownObserver());
        }
        return result;
    }

    @Nullable
    protected Observer<Long> getCountdownObserver() {
        return count -> {
            TextView countLabel;
            if (count == null) {
                return;
            }
            if (count == 0L) {
                return;
            }
            Integer duration = Long.valueOf(((ActiveUIStepView)this.stepView).getDuration().getSeconds()).intValue();
            int from = (int)((long)duration.intValue() - count);
            Animator animator = this.getCountdownAnimator(from, from + 1);
            if (animator != null) {
                animator.start();
            }
            if ((countLabel = ((ActiveUIStepViewBinding)this.stepViewBinding).getCountLabel()) != null) {
                countLabel.setText((CharSequence)String.format(this.getResources().getConfiguration().locale, "%d", count));
            }
        };
    }

    @Nullable
    protected Animator getCountdownAnimator(int from, int to) {
        ProgressBar countdownDial = ((ActiveUIStepViewBinding)this.stepViewBinding).getCountdownDial();
        if (countdownDial != null) {
            ObjectAnimator animator = ObjectAnimator.ofInt((Object)countdownDial, (String)"progress", (int[])new int[]{from * 100, to * 100});
            animator.setDuration((long)((to - from) * 1000));
            animator.setStartDelay(0L);
            animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            return animator;
        }
        return null;
    }
}

