/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.research.mobile_ui.show_step.view;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.OnApplyWindowInsetsListener;
import android.support.v4.view.WindowInsetsCompat;
import android.view.ViewGroup;
import org.sagebionetworks.research.mobile_ui.R;

public class SystemWindowHelper {
    private SystemWindowHelper() {
    }

    private static InsetChange getInsetChange(@Nullable WindowInsetsCompat oldInsets, @NonNull WindowInsetsCompat newInsets) {
        if (oldInsets == null) {
            return new InsetChange(newInsets.getSystemWindowInsetLeft(), newInsets.getSystemWindowInsetRight(), newInsets.getSystemWindowInsetTop(), newInsets.getSystemWindowInsetBottom());
        }
        return new InsetChange(newInsets.getSystemWindowInsetLeft() - oldInsets.getSystemWindowInsetLeft(), newInsets.getSystemWindowInsetRight() - oldInsets.getSystemWindowInsetRight(), newInsets.getSystemWindowInsetTop() - oldInsets.getSystemWindowInsetTop(), newInsets.getSystemWindowInsetBottom() - oldInsets.getSystemWindowInsetBottom());
    }

    public static OnApplyWindowInsetsListener getOnApplyWindowInsetsListener(Direction ... directions) {
        return (view, insets) -> {
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
            WindowInsetsCompat oldInsets = (WindowInsetsCompat)view.getTag(R.id.rs2_system_window_helper_insets_tag_key);
            InsetChange insetChange = SystemWindowHelper.getInsetChange(oldInsets, insets);
            block6: for (Direction direction : directions) {
                switch (direction) {
                    case LEFT: {
                        layoutParams.leftMargin += insetChange.left;
                        continue block6;
                    }
                    case RIGHT: {
                        layoutParams.rightMargin += insetChange.right;
                        continue block6;
                    }
                    case TOP: {
                        layoutParams.topMargin += insetChange.top;
                        continue block6;
                    }
                    case BOTTOM: {
                        layoutParams.bottomMargin += insetChange.bottom;
                    }
                }
            }
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            view.setTag(R.id.rs2_system_window_helper_insets_tag_key, (Object)insets);
            view.getParent().requestLayout();
            return insets;
        };
    }

    private static class InsetChange {
        private final int left;
        private final int right;
        private final int top;
        private final int bottom;

        private InsetChange(int left, int right, int top, int bottom) {
            this.left = left;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
        }
    }

    public static enum Direction {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

