/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.research.mobile_ui.show_step.view;

import android.os.Bundle;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.view.View;
import org.sagebionetworks.research.mobile_ui.R;
import org.sagebionetworks.research.mobile_ui.show_step.view.ShowActiveUIStepFragmentBase;
import org.sagebionetworks.research.mobile_ui.show_step.view.ShowStepFragmentBase;
import org.sagebionetworks.research.mobile_ui.show_step.view.view_binding.ActiveUIStepViewBinding;
import org.sagebionetworks.research.mobile_ui.widget.ActionButton;
import org.sagebionetworks.research.presentation.DisplayString;
import org.sagebionetworks.research.presentation.model.action.ActionView;
import org.sagebionetworks.research.presentation.model.action.ActionViewBase;
import org.sagebionetworks.research.presentation.model.interfaces.CountdownStepView;
import org.sagebionetworks.research.presentation.model.interfaces.StepView;
import org.sagebionetworks.research.presentation.model.interfaces.UIStepView;
import org.sagebionetworks.research.presentation.show_step.show_step_view_models.ShowActiveUIStepViewModel;

public class ShowCountdownStepFragment
extends ShowActiveUIStepFragmentBase<CountdownStepView, ShowActiveUIStepViewModel<CountdownStepView>, ActiveUIStepViewBinding<CountdownStepView>> {
    @Override
    public void onStart() {
        super.onStart();
        if (!((ShowActiveUIStepViewModel)this.showStepViewModel).isCountdownRunning() && !((ShowActiveUIStepViewModel)this.showStepViewModel).isCountdownPaused()) {
            ((ShowActiveUIStepViewModel)this.showStepViewModel).startCountdown();
        }
    }

    @NonNull
    public static ShowCountdownStepFragment newInstance(@NonNull StepView stepView) {
        if (!(stepView instanceof CountdownStepView)) {
            throw new IllegalArgumentException("Step view: " + stepView + " is not a CountdownStepView.");
        }
        ShowCountdownStepFragment fragment = new ShowCountdownStepFragment();
        Bundle arguments = ShowStepFragmentBase.createArguments(stepView);
        fragment.setArguments(arguments);
        return fragment;
    }

    @Override
    @LayoutRes
    public int getLayoutId() {
        return R.layout.rs2_show_countdown_step_fragment_layout;
    }

    @Override
    @NonNull
    protected ActiveUIStepViewBinding<CountdownStepView> instantiateAndBindBinding(View view) {
        return new ActiveUIStepViewBinding<CountdownStepView>(view);
    }

    @Override
    protected ActionView getForwardButtonActionView(UIStepView stepView) {
        return ActionViewBase.builder().setButtonTitle(DisplayString.create(null, (String)this.getPauseResumeCountdownButtonTitle())).build();
    }

    @Override
    protected void handleActionButtonClick(@NonNull ActionButton actionButton) {
        String actionType = this.getActionTypeFromActionButton(actionButton);
        if (actionType.equals("goForward")) {
            if (((ShowActiveUIStepViewModel)this.showStepViewModel).isCountdownRunning()) {
                ((ShowActiveUIStepViewModel)this.showStepViewModel).pauseCountdown();
            } else {
                ((ShowActiveUIStepViewModel)this.showStepViewModel).resumeCountdown();
            }
            ActionButton pauseResumeButton = ((ActiveUIStepViewBinding)this.stepViewBinding).getNextButton();
            if (pauseResumeButton != null) {
                pauseResumeButton.setText(this.getPauseResumeCountdownButtonTitle());
            }
        } else {
            super.handleActionButtonClick(actionButton);
        }
    }

    private String getPauseResumeCountdownButtonTitle() {
        if (((ShowActiveUIStepViewModel)this.showStepViewModel).isCountdownRunning()) {
            return this.getResources().getString(R.string.countdown_pause);
        }
        return this.getResources().getString(R.string.countdown_resume);
    }
}

