/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.research.mobile_ui.perform_task;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.app.AppCompatActivity;
import com.google.common.base.Preconditions;
import dagger.android.AndroidInjection;
import dagger.android.AndroidInjector;
import dagger.android.DispatchingAndroidInjector;
import dagger.android.support.HasSupportFragmentInjector;
import java.util.UUID;
import javax.inject.Inject;
import org.sagebionetworks.research.domain.result.interfaces.TaskResult;
import org.sagebionetworks.research.mobile_ui.R;
import org.sagebionetworks.research.mobile_ui.perform_task.PerformTaskFragment;
import org.sagebionetworks.research.presentation.model.TaskView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformTaskActivity
extends AppCompatActivity
implements HasSupportFragmentInjector,
PerformTaskFragment.OnPerformTaskExitListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(PerformTaskActivity.class);
    private static final String EXTRA_TASK_VIEW = "TASK_VIEW";
    private static final String EXTRA_TASK_RUN_UUID = "TASK_RUN_UUID";
    @Inject
    DispatchingAndroidInjector<Fragment> supportFragmentInjector;

    public static Intent createIntent(@NonNull Context context, @NonNull TaskView taskView, @Nullable UUID taskRunUUID) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)taskView);
        Intent launchIntent = new Intent(context, PerformTaskActivity.class).putExtra(EXTRA_TASK_VIEW, (Parcelable)taskView);
        if (taskRunUUID != null) {
            launchIntent.putExtra(EXTRA_TASK_RUN_UUID, (Parcelable)new ParcelUuid(taskRunUUID));
        }
        return launchIntent;
    }

    public void onCreate(Bundle savedInstanceState) {
        PerformTaskFragment performTaskFragment;
        AndroidInjection.inject((Activity)this);
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.rs2_perform_task_activity_layout);
        TaskView taskView = (TaskView)this.getIntent().getParcelableExtra(EXTRA_TASK_VIEW);
        UUID taskRunUuid = null;
        ParcelUuid taskRunParcelableUuid = (ParcelUuid)this.getIntent().getParcelableExtra(EXTRA_TASK_RUN_UUID);
        if (taskRunParcelableUuid != null) {
            taskRunUuid = taskRunParcelableUuid.getUuid();
        }
        if (taskRunUuid == null) {
            LOGGER.debug("No taskRunUuid found, generating random");
            taskRunUuid = UUID.randomUUID();
        }
        if ((performTaskFragment = (PerformTaskFragment)this.getSupportFragmentManager().findFragmentById(R.id.rs2_task_content_frame)) == null) {
            performTaskFragment = PerformTaskFragment.newInstance(taskView, taskRunUuid);
            this.getSupportFragmentManager().beginTransaction().add(R.id.rs2_task_content_frame, (Fragment)performTaskFragment).commit();
        }
    }

    @Override
    public void onTaskExit(@NonNull PerformTaskFragment.OnPerformTaskExitListener.Status status, @NonNull TaskResult taskResult) {
        LOGGER.info("Task exited with status: {}, taskResult: {}", (Object)status, (Object)taskResult);
        this.finish();
    }

    public AndroidInjector<Fragment> supportFragmentInjector() {
        return this.supportFragmentInjector;
    }
}

