/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.research.data;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.google.gson.Gson;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import org.sagebionetworks.research.domain.async.AsyncActionConfiguration;
import org.sagebionetworks.research.domain.async.RecorderConfiguration;
import org.sagebionetworks.research.domain.repository.TaskRepository;
import org.sagebionetworks.research.domain.result.interfaces.TaskResult;
import org.sagebionetworks.research.domain.step.interfaces.SectionStep;
import org.sagebionetworks.research.domain.step.interfaces.Step;
import org.sagebionetworks.research.domain.step.interfaces.TransformerStep;
import org.sagebionetworks.research.domain.task.Task;
import org.sagebionetworks.research.domain.task.TaskInfoView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceTaskRepository
implements TaskRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceTaskRepository.class);
    protected final Context context;
    protected final Gson gson;
    protected final Map<UUID, TaskResult> taskResultMap;

    @Inject
    public ResourceTaskRepository(Context context, Gson gson) {
        this.context = context;
        this.gson = gson;
        this.taskResultMap = new HashMap<UUID, TaskResult>();
    }

    @NonNull
    public InputStreamReader getJsonTaskAsset(String assetName) throws IOException {
        String assetPath = "task/" + assetName + ".json";
        return this.getAsset(assetPath);
    }

    @NonNull
    public InputStreamReader getJsonTaskInfoAsset(String assetName) throws IOException {
        String assetPath = "task/info/" + assetName + ".json";
        return this.getAsset(assetPath);
    }

    @NonNull
    public InputStreamReader getJsonTransformerAsset(String assetName) throws IOException {
        String assetPath = "task/transformer/" + assetName;
        return this.getAsset(assetPath);
    }

    @NonNull
    public Single<Task> getTask(String taskIdentifier) {
        return Single.fromCallable(() -> {
            Task task = (Task)this.gson.fromJson((Reader)this.getJsonTaskAsset(taskIdentifier), Task.class);
            ImmutableList taskSteps = task.getSteps();
            ArrayList<Step> steps = new ArrayList<Step>();
            for (Step step : taskSteps) {
                steps.add(this.resolveTransformers(step, ""));
            }
            task = task.copyWithSteps(steps);
            task = task.copyWithAsyncActions(ResourceTaskRepository.getAsyncActions(task));
            return task;
        }).doOnSuccess(t -> LOGGER.debug("Successfully loaded task: {}", t)).doOnError(throwable -> LOGGER.warn("Error loading task with id: {}", (Object)taskIdentifier, throwable));
    }

    @NonNull
    public Single<TaskInfoView> getTaskInfo(String taskIdentifier) {
        return Single.fromCallable(() -> (TaskInfoView)this.gson.fromJson((Reader)this.getJsonTaskInfoAsset(taskIdentifier), TaskInfoView.class));
    }

    @NonNull
    public Maybe<TaskResult> getTaskResult(UUID taskRunUUID) {
        TaskResult taskResult = this.taskResultMap.get(taskRunUUID);
        if (taskResult == null) {
            return Maybe.empty();
        }
        return Maybe.just((Object)taskResult);
    }

    @DrawableRes
    public int resolveDrawableFromString(@NonNull String name) throws Resources.NotFoundException {
        int resId = this.context.getResources().getIdentifier(name, "drawable", this.context.getPackageName());
        if (resId == 0) {
            throw new Resources.NotFoundException("Resource " + name + " couldn't be resolved as a drawable.");
        }
        return resId;
    }

    @NonNull
    public Completable setTaskResult(TaskResult taskResult) {
        this.taskResultMap.put(taskResult.getTaskUUID(), taskResult);
        return Completable.complete();
    }

    @NonNull
    private InputStreamReader getAsset(String assetPath) throws IOException {
        AssetManager assetManager = this.context.getAssets();
        return new InputStreamReader(assetManager.open(assetPath), StandardCharsets.UTF_8);
    }

    private Step resolveTransformers(Step step, String prefix) throws IOException {
        if (step instanceof TransformerStep) {
            TransformerStep transformer = (TransformerStep)step;
            SectionStep result = (SectionStep)this.gson.fromJson((Reader)this.getJsonTransformerAsset(transformer.getResourceName()), SectionStep.class);
            result = result.copyWithIdentifier(prefix + transformer.getIdentifier());
            return this.resolveTransformers((Step)result, prefix);
        }
        if (step instanceof SectionStep) {
            SectionStep section = (SectionStep)step;
            ImmutableList steps = section.getSteps();
            ImmutableList.Builder builder = new ImmutableList.Builder();
            for (Step innerStep : steps) {
                builder.add((Object)this.resolveTransformers(innerStep, prefix + section.getIdentifier() + "_"));
            }
            return section.copyWithSteps((List)builder.build());
        }
        Step copiedStep = step.copyWithIdentifier(prefix + step.getIdentifier());
        if (copiedStep.getClass() != step.getClass()) {
            LOGGER.warn("Copied step ({}) has different class than the original({})", (Object)copiedStep, (Object)step);
        }
        return step.copyWithIdentifier(prefix + step.getIdentifier());
    }

    private static Set<AsyncActionConfiguration> getAsyncActions(Task task) {
        return ResourceTaskRepository.getAsyncActionsHelper((List<Step>)task.getSteps(), new HashSet<AsyncActionConfiguration>((Collection<AsyncActionConfiguration>)task.getAsyncActions()));
    }

    private static Set<AsyncActionConfiguration> getAsyncActionsHelper(List<Step> steps, Set<AsyncActionConfiguration> accumlator) {
        for (Step step : steps) {
            String defaultStartIdentifier = step.getIdentifier();
            String defaultStopIdentifier = null;
            if (step instanceof SectionStep) {
                defaultStartIdentifier = ResourceTaskRepository.getLeftMostChild(step).getIdentifier();
                defaultStopIdentifier = ResourceTaskRepository.getRightMostChild(step).getIdentifier();
                SectionStep sectionStep = (SectionStep)step;
                ResourceTaskRepository.getAsyncActionsHelper((List<Step>)sectionStep.getSteps(), accumlator);
            }
            UnmodifiableIterator unmodifiableIterator = step.getAsyncActions().iterator();
            while (unmodifiableIterator.hasNext()) {
                AsyncActionConfiguration asyncAction;
                AsyncActionConfiguration copy = asyncAction = (AsyncActionConfiguration)unmodifiableIterator.next();
                if (asyncAction.getStartStepIdentifier() == null) {
                    copy = copy.copyWithStartStepIdentifier(defaultStartIdentifier);
                } else if (step instanceof SectionStep) {
                    copy = copy.copyWithStartStepIdentifier(step.getIdentifier() + "_" + copy.getStartStepIdentifier());
                }
                if (copy instanceof RecorderConfiguration) {
                    RecorderConfiguration recorderConfiguration = (RecorderConfiguration)copy;
                    if (recorderConfiguration.getStopStepIdentifier() == null) {
                        recorderConfiguration = recorderConfiguration.copyWithStopStepIdentifier(defaultStopIdentifier);
                    } else if (step instanceof SectionStep) {
                        recorderConfiguration = recorderConfiguration.copyWithStopStepIdentifier(step.getIdentifier() + "_" + recorderConfiguration.getStopStepIdentifier());
                    }
                    copy = recorderConfiguration;
                }
                copy = copy.copyWithIdentifier(step.getIdentifier() + "_" + copy.getIdentifier());
                accumlator.add(copy);
            }
        }
        return accumlator;
    }

    private static Step getLeftMostChild(Step step) {
        while (step instanceof SectionStep) {
            step = (Step)((SectionStep)step).getSteps().get(0);
        }
        return step;
    }

    private static Step getRightMostChild(Step step) {
        while (step instanceof SectionStep) {
            ImmutableList steps = ((SectionStep)step).getSteps();
            step = (Step)steps.get(steps.size() - 1);
        }
        return step;
    }
}

