/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.bridge.android.manager.dao;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sagebionetworks.bridge.android.di.BridgeStudyScope;
import org.sagebionetworks.bridge.android.manager.dao.SharedPreferencesJsonDAO;
import org.sagebionetworks.bridge.rest.model.ScheduledActivity;
import org.sagebionetworks.bridge.rest.model.ScheduledActivityListV4;

@BridgeStudyScope
public class ActivityListDAO
extends SharedPreferencesJsonDAO {
    private static final String LOG_TAG = ActivityListDAO.class.getCanonicalName();
    private static final TypeToken<List<ScheduledActivity>> ACTIVITY_LIST_TYPE = new TypeToken<List<ScheduledActivity>>(){};
    private static final String ACTIVITIES_KEY = "ACTIVITIES";

    public ActivityListDAO(@NonNull Context applicationContext, @NonNull String prefsKey) {
        super(applicationContext, prefsKey);
    }

    public void clear() {
        this.sharedPreferences.edit().clear().commit();
    }

    public void removeActivity(@Nullable ScheduledActivity activity) {
        if (activity == null) {
            return;
        }
        List<ScheduledActivity> activityList = this.getActivityList();
        ScheduledActivity activityToUpdate = this.findActivity(activityList, activity.getGuid());
        if (activityToUpdate != null) {
            activityList.remove(activityToUpdate);
        }
        if (activityList != null) {
            this.cacheActivityList(activityList);
        }
    }

    public void updateActivityList(@Nullable ScheduledActivityListV4 activitiesToUpdate) {
        if (activitiesToUpdate == null) {
            return;
        }
        this.updateActivityList(activitiesToUpdate.getItems());
    }

    public void updateActivity(@Nullable ScheduledActivity activityToUpdate) {
        if (activityToUpdate == null) {
            return;
        }
        this.updateActivityList(Collections.singletonList(activityToUpdate));
    }

    public void updateActivityList(@Nullable List<ScheduledActivity> activitiesToUpdate) {
        if (activitiesToUpdate == null || activitiesToUpdate.isEmpty()) {
            return;
        }
        List<ScheduledActivity> activityList = this.getActivityList();
        if (activityList == null) {
            activityList = new ArrayList<ScheduledActivity>();
        }
        for (ScheduledActivity activity : activitiesToUpdate) {
            ScheduledActivity activityToUpdate = this.findActivity(activityList, activity.getGuid());
            if (activityToUpdate != null) {
                activityList.remove(activityToUpdate);
            }
            activityList.add(activity);
        }
        this.cacheActivityList(activityList);
    }

    protected void cacheActivityList(@NonNull List<ScheduledActivity> onceActivityList) {
        this.setValue(ACTIVITIES_KEY, onceActivityList, ACTIVITY_LIST_TYPE);
    }

    @Nullable
    public List<ScheduledActivity> getActivityList() {
        return this.getValue(ACTIVITIES_KEY, ACTIVITY_LIST_TYPE);
    }

    @Nullable
    public ScheduledActivity getActivity(String guid) {
        return this.findActivity(this.getActivityList(), guid);
    }

    public boolean hasActivityList() {
        return this.sharedPreferences.contains(ACTIVITIES_KEY);
    }

    protected ScheduledActivity findActivity(@Nullable List<ScheduledActivity> activityList, @Nullable String guid) {
        if (guid == null || activityList == null) {
            return null;
        }
        for (ScheduledActivity activity : activityList) {
            if (!guid.equals(activity.getGuid())) continue;
            return activity;
        }
        return null;
    }
}

