/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.bridge.android.viewmodel;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.inject.Inject;
import org.sagebionetworks.bridge.android.access.Resource;
import org.sagebionetworks.bridge.android.manager.AuthenticationManager;
import org.sagebionetworks.bridge.android.manager.dao.AccountDAO;
import org.sagebionetworks.bridge.rest.model.Phone;
import org.sagebionetworks.bridge.rest.model.UserSessionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.subscriptions.CompositeSubscription;

public class PhoneAuthViewModel
extends ViewModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhoneAuthViewModel.class);
    private final CompositeSubscription compositeSubscription = new CompositeSubscription();
    private final AuthenticationManager authenticationManager;
    private final AccountDAO accountDAO;
    private final MutableLiveData<Resource<Object>> signInStateLiveData;

    public PhoneAuthViewModel(AuthenticationManager authenticationManager, AccountDAO accountDAO) {
        this.authenticationManager = authenticationManager;
        this.accountDAO = accountDAO;
        this.signInStateLiveData = new MutableLiveData();
    }

    public LiveData<Resource<Object>> getSignInStateLiveData() {
        return this.signInStateLiveData;
    }

    public void signInWithToken(String token) {
        String phoneRegion = this.accountDAO.getPhoneRegion();
        String phoneNumber = this.accountDAO.getPhoneNumber();
        boolean newSignIn = false;
        newSignIn = this.isNewSignIn(phoneRegion, phoneNumber);
        if (newSignIn) {
            this.doPhoneSignIn(token, phoneRegion, phoneNumber);
        } else {
            this.refreshSessionOrSignIn(token, phoneRegion, phoneNumber);
        }
    }

    @VisibleForTesting
    void refreshSessionOrSignIn(String token, String phoneRegion, String phoneNumber) {
        this.doPhoneSignIn(token, phoneRegion, phoneNumber);
    }

    @VisibleForTesting
    boolean isNewSignIn(String phoneRegion, String phoneNumber) {
        Phone phone;
        UserSessionInfo currentSession = this.authenticationManager.getUserSessionInfo();
        boolean newSignIn = currentSession == null ? true : !this.isSamePhone(phone = currentSession.getPhone(), phoneRegion, phoneNumber);
        return newSignIn;
    }

    @VisibleForTesting
    boolean isSamePhone(Phone expected, String phoneRegion, String phoneNumber) {
        return expected != null && expected.getRegionCode().equals(phoneRegion) && phoneNumber != null && expected.getNumber().endsWith(phoneNumber);
    }

    @VisibleForTesting
    void doPhoneSignIn(String token, String phoneRegion, String phoneNumber) {
        if (Strings.isNullOrEmpty((String)token)) {
            LOGGER.error("Received null or empty token");
            this.signInStateLiveData.postValue(Resource.error("Unable to process sign in link. Please sign in again to get a new link by SMS", new Object()));
            return;
        }
        if (Strings.isNullOrEmpty((String)phoneRegion) || Strings.isNullOrEmpty((String)phoneNumber)) {
            LOGGER.warn("Phone number and region are required and were not found in accountDAO");
            this.signInStateLiveData.postValue(Resource.error("Phone number unknown. Please sign in again to get a new link by SMS", new Object()));
            return;
        }
        this.compositeSubscription.add(this.authenticationManager.signInViaPhoneLink(phoneRegion, phoneNumber, token).subscribe(session -> {
            LOGGER.debug("TokenLoginSubscribe: Authenticated Login Complete");
            this.signInStateLiveData.postValue(Resource.success(new Object()));
        }, throwable -> {
            LOGGER.warn("Sign up failed", throwable);
            this.signInStateLiveData.postValue(Resource.error("Error signing in: \n" + throwable.getMessage(), new Object()));
        }));
    }

    protected void onCleared() {
        super.onCleared();
        this.compositeSubscription.clear();
    }

    public static class Factory
    implements ViewModelProvider.Factory {
        private final AuthenticationManager authenticationManager;
        private final AccountDAO accountDAO;

        @Inject
        public Factory(AuthenticationManager authenticationManager, AccountDAO accountDAO) {
            this.authenticationManager = authenticationManager;
            this.accountDAO = accountDAO;
        }

        @NonNull
        public <T extends ViewModel> T create(@NonNull Class<T> modelClass) {
            Preconditions.checkArgument((boolean)modelClass.isAssignableFrom(PhoneAuthViewModel.class));
            return (T)((Object)new PhoneAuthViewModel(this.authenticationManager, this.accountDAO));
        }
    }
}

