/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.bridge.android.receiver;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import javax.inject.Inject;
import org.sagebionetworks.bridge.android.BridgeConfig;

public class AppVersionManager {
    private static final String SHARED_PREFS_FILE = "org.sagebionetworks.bridge.AppVersion";
    private static final String PREFS_KEY_UPGRADE_REQUIRED = "APP_UPGRADE_REQUIRED_FROM_VERSION";
    private final SharedPreferences appVersionSharedPreferences;
    private final BridgeConfig bridgeConfig;

    @Inject
    public AppVersionManager(Context context, BridgeConfig bridgeConfig) {
        this.appVersionSharedPreferences = context.getSharedPreferences(SHARED_PREFS_FILE, 0);
        this.bridgeConfig = bridgeConfig;
    }

    @NonNull
    public boolean isUpgradeRequired() {
        int upgradeRequiredVersion = this.appVersionSharedPreferences.getInt(PREFS_KEY_UPGRADE_REQUIRED, 0);
        return this.bridgeConfig.getAppVersion() <= upgradeRequiredVersion;
    }

    public void setUpgradeRequired() {
        this.appVersionSharedPreferences.edit().putInt(PREFS_KEY_UPGRADE_REQUIRED, this.bridgeConfig.getAppVersion()).apply();
    }

    @VisibleForTesting
    SharedPreferences getAppVersionSharedPreferences() {
        return this.appVersionSharedPreferences;
    }
}

