/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.bridge.android.manager.upload;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.joda.time.DateTime;
import org.sagebionetworks.bridge.data.JsonArchiveFile;
import org.sagebionetworks.bridge.rest.RestUtils;
import org.sagebionetworks.bridge.rest.model.Activity;
import org.sagebionetworks.bridge.rest.model.ScheduledActivity;
import org.sagebionetworks.bridge.rest.model.TaskReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchiveUtil.class);

    private ArchiveUtil() {
    }

    @NonNull
    public static JsonArchiveFile createMetaDataFile(@NonNull ScheduledActivity scheduledActivity, @NonNull ImmutableList<String> dataGroups) {
        return ArchiveUtil.createMetaDataFile(scheduledActivity, dataGroups, null);
    }

    @NonNull
    public static JsonArchiveFile createMetaDataFile(@NonNull ScheduledActivity scheduledActivity, @NonNull ImmutableList<String> dataGroups, @Nullable String userExternalId) {
        Preconditions.checkNotNull((Object)scheduledActivity);
        Preconditions.checkNotNull(dataGroups);
        Map<String, Object> metaDataMap = ArchiveUtil.createMetaDataInfoMap(scheduledActivity, dataGroups, userExternalId);
        DateTime endDate = DateTime.now();
        if (scheduledActivity.getFinishedOn() != null) {
            endDate = scheduledActivity.getFinishedOn();
        }
        String metaDataJson = RestUtils.GSON.toJson(metaDataMap);
        return new JsonArchiveFile("metadata.json", endDate, metaDataJson);
    }

    public static Map<String, Object> createMetaDataInfoMap(@NonNull ScheduledActivity scheduledActivity, @NonNull ImmutableList<String> dataGroups, @Nullable String externalId) {
        HashMap<String, Object> metaDataMap = new HashMap<String, Object>();
        DateTime endDate = DateTime.now();
        if (scheduledActivity.getFinishedOn() != null) {
            endDate = scheduledActivity.getFinishedOn();
        }
        metaDataMap.put("endDate", endDate);
        if (scheduledActivity.getActivity() != null && scheduledActivity.getActivity().getTask() != null) {
            Activity activity = scheduledActivity.getActivity();
            TaskReference taskRef = activity.getTask();
            String taskIdentifier = taskRef.getIdentifier();
            if (taskIdentifier != null) {
                metaDataMap.put("taskIdentifier", taskIdentifier);
            }
            if (activity.getLabel() != null) {
                metaDataMap.put("activityLabel", activity.getLabel());
            }
        }
        if (scheduledActivity.getGuid() != null) {
            metaDataMap.put("scheduledActivityGuid", scheduledActivity.getGuid());
        }
        metaDataMap.put("taskRunUUID", UUID.randomUUID().toString());
        if (scheduledActivity.getStartedOn() != null) {
            metaDataMap.put("startDate", scheduledActivity.getStartedOn());
        }
        if (scheduledActivity.getScheduledOn() != null) {
            metaDataMap.put("scheduledOn", scheduledActivity.getScheduledOn().toDate());
        }
        if (scheduledActivity.getSchedulePlanGuid() != null) {
            metaDataMap.put("scheduleIdentifier", scheduledActivity.getSchedulePlanGuid());
        }
        if (externalId != null) {
            metaDataMap.put("externalId", externalId);
        }
        metaDataMap.put("dataGroups", TextUtils.join((CharSequence)",", dataGroups));
        return metaDataMap;
    }
}

