/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.bridge.android.manager.dao;

import android.content.Context;
import android.support.annotation.AnyThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.sagebionetworks.bridge.android.di.BridgeStudyScope;
import org.sagebionetworks.bridge.android.manager.dao.SharedPreferencesJsonDAO;
import org.sagebionetworks.bridge.rest.model.ConsentSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BridgeStudyScope
@AnyThread
public class ConsentDAO
extends SharedPreferencesJsonDAO {
    private static final Logger logger = LoggerFactory.getLogger(ConsentDAO.class);
    private static final String PREFERENCES_FILE = "consents";
    private static final String CONSENT_KEY_PREFIX = "subpopulation-";

    @Inject
    public ConsentDAO(Context applicationContext) {
        super(applicationContext, PREFERENCES_FILE);
    }

    public void clear() {
        this.sharedPreferences.edit().clear().commit();
    }

    @NonNull
    public Set<String> listConsents() {
        HashSet subpopulations = Sets.newHashSet();
        for (String key : this.sharedPreferences.getAll().keySet()) {
            if (!key.startsWith(CONSENT_KEY_PREFIX)) continue;
            String subpopulation = key.substring(CONSENT_KEY_PREFIX.length());
            subpopulations.add(subpopulation);
        }
        logger.debug("listConsents called, found subpopulations: " + subpopulations);
        return subpopulations;
    }

    @Nullable
    public ConsentSignature getConsent(@NonNull String subpopulationGuid) {
        Preconditions.checkNotNull((Object)subpopulationGuid);
        ConsentSignature consentSignature = this.getValue(this.consentKey(subpopulationGuid), ConsentSignature.class);
        logger.debug("getConsent called for subpopulation " + subpopulationGuid + ", found: " + consentSignature);
        return consentSignature;
    }

    public void putConsent(@NonNull String subpopulationGuid, @NonNull ConsentSignature consentSignature) {
        Preconditions.checkNotNull((Object)subpopulationGuid);
        Preconditions.checkNotNull((Object)consentSignature);
        logger.debug("putConsent called for subpopulations " + subpopulationGuid + ", with: " + consentSignature);
        this.setValue(this.consentKey(subpopulationGuid), consentSignature, ConsentSignature.class);
    }

    public void removeConsent(@NonNull String subpopulationGuid) {
        Preconditions.checkNotNull((Object)subpopulationGuid);
        this.removeValue(this.consentKey(subpopulationGuid));
    }

    private String consentKey(String subpopulationGuid) {
        return CONSENT_KEY_PREFIX + subpopulationGuid;
    }
}

