/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.bridge.android.manager.upload;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public class FileUploadRequestBody
extends RequestBody {
    private static final int SEGMENT_SIZE = 8192;
    private final File file;
    private final ProgressListener listener;
    private final String contentType;

    public FileUploadRequestBody(File file, String contentType, ProgressListener listener) {
        this.file = file;
        this.contentType = contentType;
        this.listener = listener;
    }

    public long contentLength() {
        return this.file.length();
    }

    public MediaType contentType() {
        return MediaType.parse((String)this.contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(BufferedSink sink) throws IOException {
        Source source = null;
        try {
            long read;
            source = Okio.source((File)this.file);
            long total = 0L;
            while ((read = source.read(sink.buffer(), 8192L)) != -1L) {
                sink.flush();
                this.listener.transferred(total += read);
            }
        }
        finally {
            Util.closeQuietly((Closeable)source);
        }
    }

    public static interface ProgressListener {
        public void transferred(long var1);
    }
}

