/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.bridge.android;

import android.app.Application;
import android.content.Context;
import android.support.multidex.MultiDex;
import com.facebook.stetho.Stetho;
import dagger.android.AndroidInjector;
import dagger.android.support.DaggerApplication;
import net.danlew.android.joda.JodaTimeAndroid;
import org.sagebionetworks.bridge.android.R;
import org.sagebionetworks.bridge.android.di.BridgeStudyComponent;
import org.sagebionetworks.bridge.android.di.DaggerBridgeApplicationComponent;
import org.sagebionetworks.bridge.android.di.DaggerBridgeStudyComponent;
import org.sagebionetworks.bridge.android.manager.BridgeManagerProvider;
import org.sagebionetworks.bridge.android.manager.DaggerBridgeManagerProvider;

public class BridgeApplication
extends DaggerApplication {
    private static BridgeManagerProvider bridgeManagerProvider;

    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        MultiDex.install((Context)this);
    }

    public void onCreate() {
        JodaTimeAndroid.init((Context)this);
        super.onCreate();
        this.getOrInitBridgeManagerProvider();
        if (this.getResources().getBoolean(R.bool.osb_stetho_debug_bridge)) {
            this.initStetho();
        }
    }

    public final BridgeManagerProvider getOrInitBridgeManagerProvider() {
        BridgeManagerProvider bridgeManagerProvider;
        if (BridgeApplication.bridgeManagerProvider != null) {
            return BridgeApplication.bridgeManagerProvider;
        }
        BridgeStudyComponent bridgeStudyComponent = DaggerBridgeStudyComponent.builder().applicationContext(this.getApplicationContext()).build();
        BridgeApplication.bridgeManagerProvider = bridgeManagerProvider = this.initBridgeManagerScopedComponent(bridgeStudyComponent);
        return bridgeManagerProvider;
    }

    protected BridgeManagerProvider initBridgeManagerScopedComponent(BridgeStudyComponent bridgeStudyComponent) {
        BridgeManagerProvider bridgeManagerProvider = DaggerBridgeManagerProvider.builder().applicationContext(this.getApplicationContext()).bridgeStudyComponent(bridgeStudyComponent).build();
        return bridgeManagerProvider;
    }

    protected AndroidInjector<? extends DaggerApplication> applicationInjector() {
        return DaggerBridgeApplicationComponent.builder().application((Application)this).bridgeManagerProvider(this.getOrInitBridgeManagerProvider()).build();
    }

    protected void initStetho() {
        Stetho.initialize((Stetho.Initializer)Stetho.newInitializerBuilder((Context)this).enableWebKitInspector(Stetho.defaultInspectorModulesProvider((Context)this)).enableDumpapp(Stetho.defaultDumperPluginsProvider((Context)this)).build());
    }

    public static BridgeManagerProvider getBridgeManagerProvider() {
        return bridgeManagerProvider;
    }
}

