/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.bridge.android.manager.dao;

import android.content.Context;
import android.support.annotation.AnyThread;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.sagebionetworks.bridge.android.di.BridgeStudyScope;
import org.sagebionetworks.bridge.android.manager.UploadManager;
import org.sagebionetworks.bridge.android.manager.dao.SharedPreferencesJsonDAO;
import org.sagebionetworks.bridge.rest.model.UploadSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BridgeStudyScope
@AnyThread
public class UploadDAO
extends SharedPreferencesJsonDAO {
    private static final Logger logger = LoggerFactory.getLogger(UploadDAO.class);
    private static final String PREFERENCES_FILE = "uploads";
    private static final String UPLOAD_FILE_PREFIX = "uploadFile-";
    private static final String UPLOAD_SESSION_PREFIX = "uploadSession-";

    @Inject
    public UploadDAO(Context applicationContext) {
        super(applicationContext, PREFERENCES_FILE);
    }

    public Set<String> listUploadFilenames() {
        HashSet filenames = Sets.newHashSet();
        for (String key : this.sharedPreferences.getAll().keySet()) {
            if (!key.startsWith(UPLOAD_FILE_PREFIX)) continue;
            String filename = key.substring(UPLOAD_FILE_PREFIX.length());
            filenames.add(filename);
        }
        logger.debug("listUploadFilenames called, found: " + filenames);
        return filenames;
    }

    public void putUploadFile(String filename, UploadManager.UploadFile uploadFile) {
        this.setValue(UPLOAD_FILE_PREFIX + filename, uploadFile, UploadManager.UploadFile.class);
    }

    public UploadManager.UploadFile getUploadFile(String filename) {
        return this.getValue(UPLOAD_FILE_PREFIX + filename, UploadManager.UploadFile.class);
    }

    public void putUploadSession(String filename, UploadSession uploadSession) {
        this.setValue(UPLOAD_SESSION_PREFIX + filename, uploadSession, UploadSession.class);
    }

    public UploadSession getUploadSession(String filename) {
        return this.getValue(UPLOAD_SESSION_PREFIX + filename, UploadSession.class);
    }

    public void removeUploadAndSession(String filename) {
        this.removeValue(UPLOAD_FILE_PREFIX + filename);
        this.removeValue(UPLOAD_SESSION_PREFIX + filename);
    }
}

