/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.bridge.android.util;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.List;
import org.joda.time.LocalDate;
import org.sagebionetworks.bridge.rest.model.ScheduledActivity;
import org.sagebionetworks.bridge.rest.model.TaskReference;

public class ScheduledActivityUtil {
    public static final Function<ScheduledActivity, String> TO_SCHEDULE_PLAN_GUID = new Function<ScheduledActivity, String>(){

        @NonNull
        public String apply(@NonNull ScheduledActivity scheduledActivity) {
            Preconditions.checkNotNull((Object)scheduledActivity);
            return scheduledActivity.getSchedulePlanGuid();
        }
    };
    public static final Function<ScheduledActivity, LocalDate> TO_SCHEDULE_ON_LOCAL_DATE = new Function<ScheduledActivity, LocalDate>(){

        @NonNull
        public LocalDate apply(@NonNull ScheduledActivity scheduledActivity) {
            Preconditions.checkNotNull((Object)scheduledActivity);
            return scheduledActivity.getScheduledOn().toLocalDate();
        }
    };
    public static final Function<ScheduledActivity, String> TO_TASK_IDENTIFIER = new Function<ScheduledActivity, String>(){

        @Nullable
        public String apply(@NonNull ScheduledActivity scheduledActivity) {
            Preconditions.checkNotNull((Object)scheduledActivity);
            Verify.verify((scheduledActivity.getActivity() != null ? 1 : 0) != 0);
            TaskReference task = scheduledActivity.getActivity().getTask();
            if (task == null) {
                return null;
            }
            String taskId = task.getIdentifier();
            Verify.verify((taskId != null ? 1 : 0) != 0);
            return taskId;
        }
    };

    @NonNull
    public static ImmutableMultimap<String, ScheduledActivity> groupBySchedulePlan(@NonNull List<ScheduledActivity> activities) {
        Preconditions.checkNotNull(activities);
        return ImmutableMultimap.copyOf((Multimap)Multimaps.index(activities.iterator(), TO_SCHEDULE_PLAN_GUID));
    }

    @NonNull
    public static ImmutableMultimap<LocalDate, ScheduledActivity> groupByLocalDate(@NonNull List<ScheduledActivity> activities) {
        Preconditions.checkNotNull(activities);
        return ImmutableMultimap.copyOf((Multimap)Multimaps.index(activities.iterator(), TO_SCHEDULE_ON_LOCAL_DATE));
    }
}

