/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.bridge.android.manager;

import android.content.Context;
import android.support.annotation.AnyThread;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.sagebionetworks.bridge.android.di.BridgeStudyParticipantScope;
import org.sagebionetworks.bridge.android.manager.AuthenticationManager;
import org.sagebionetworks.bridge.android.manager.dao.ActivityListDAO;
import org.sagebionetworks.bridge.android.util.retrofit.RxUtils;
import org.sagebionetworks.bridge.rest.model.Message;
import org.sagebionetworks.bridge.rest.model.ScheduledActivity;
import org.sagebionetworks.bridge.rest.model.ScheduledActivityListV4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Single;

@BridgeStudyParticipantScope
@AnyThread
public class ActivityManager {
    private static final Logger LOG = LoggerFactory.getLogger(ActivityManager.class);
    @NonNull
    private final AtomicReference<AuthenticationManager.AuthStateHolder> authStateHolderAtomicReference;
    private static final String ACTIVITY_LIST_SHARED_PREFS_KEY = "ActivityListDAO";
    private final ActivityListDAO activityListDAO;

    @Inject
    public ActivityManager(@NonNull AuthenticationManager authenticationManager, @NonNull Context appContext) {
        Preconditions.checkNotNull((Object)authenticationManager);
        Preconditions.checkNotNull((Object)appContext);
        this.authStateHolderAtomicReference = authenticationManager.getAuthStateReference();
        this.activityListDAO = new ActivityListDAO(appContext, ACTIVITY_LIST_SHARED_PREFS_KEY);
    }

    public Single<ScheduledActivityListV4> getActivities(@NonNull DateTime startTime, @NonNull DateTime endTime) {
        DateTime requestEndTime = endTime;
        try {
            int startOffset = startTime.getZone().getOffset((ReadableInstant)startTime);
            int endOffset = endTime.getZone().getOffset((ReadableInstant)endTime);
            if (startOffset != endOffset) {
                requestEndTime = endTime.toDateTime(DateTimeZone.forOffsetMillis((int)startOffset));
                LOG.warn("Correcting for mismatched offset. startTime: {}, endTime: {}, newEndTime: {}", new Object[]{startTime, endTime, requestEndTime});
            }
        }
        catch (Exception e) {
            return Single.error((Throwable)e);
        }
        return RxUtils.toBodySingle(this.authStateHolderAtomicReference.get().forConsentedUsersApi.getScheduledActivitiesByDateRange(startTime, requestEndTime)).doOnSuccess(scheduleActivityList -> {
            LOG.debug("Got scheduled activity list");
            this.activityListDAO.updateActivityList((ScheduledActivityListV4)scheduleActivityList);
        }).doOnError(throwable -> LOG.error(throwable.getMessage()));
    }

    @CheckResult
    public Single<Message> updateActivities(@NonNull List<ScheduledActivity> scheduledActivities) {
        Preconditions.checkNotNull(scheduledActivities);
        this.activityListDAO.updateActivityList(scheduledActivities);
        return RxUtils.toBodySingle(this.authStateHolderAtomicReference.get().forConsentedUsersApi.updateScheduledActivities(scheduledActivities));
    }

    @CheckResult
    public Observable<Message> updateActivity(@NonNull ScheduledActivity scheduledActivity) {
        Preconditions.checkNotNull((Object)scheduledActivity);
        return this.updateActivities(Collections.singletonList(scheduledActivity)).toObservable();
    }

    @Nullable
    public ScheduledActivity getLocalActivity(String guid) {
        return this.activityListDAO.getActivity(guid);
    }

    public void clearDAO() {
        this.activityListDAO.clear();
    }
}

