/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.bridge.android.manager.dao;

import android.content.Context;
import android.support.annotation.AnyThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import javax.inject.Inject;
import org.sagebionetworks.bridge.android.di.BridgeStudyScope;
import org.sagebionetworks.bridge.android.manager.dao.SharedPreferencesJsonDAO;
import org.sagebionetworks.bridge.rest.model.AppConfig;

@BridgeStudyScope
@AnyThread
public class AppConfigDAO
extends SharedPreferencesJsonDAO {
    private static final String APP_CONFIG_KEY = "APP_CONFIG";
    private static final String PREFERENCES_FILE = "appconfig";

    @Inject
    public AppConfigDAO(@NonNull Context applicationContext) {
        super(applicationContext, PREFERENCES_FILE);
    }

    public void cacheAppConfig(@NonNull AppConfig appConfig) {
        this.setValue(APP_CONFIG_KEY, appConfig, AppConfig.class);
    }

    @Nullable
    public AppConfig getAppConfig() {
        return this.getValue(APP_CONFIG_KEY, AppConfig.class);
    }

    public void removeAppConfig() {
        this.removeValue(APP_CONFIG_KEY);
    }
}

