/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.bridge.android;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import java.net.UnknownHostException;
import org.sagebionetworks.bridge.android.manager.BridgeManagerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.android.schedulers.AndroidSchedulers;
import rx.subscriptions.CompositeSubscription;

public class AuthManagementActivity
extends Activity {
    private static final Logger logger = LoggerFactory.getLogger(AuthManagementActivity.class);
    private final CompositeSubscription compositeSubscription = new CompositeSubscription();

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().getDecorView().setBackgroundColor(0);
        Uri data = this.getIntent().getData();
        if (data == null) {
            logger.warn("Intent did not contain any data, aborting.");
            return;
        }
        switch (data.getLastPathSegment()) {
            case "startSession.html": {
                this.startSession(data);
                break;
            }
            case "verifyEmail.html": {
                this.startSession(data);
                break;
            }
            default: {
                this.startSession(data);
            }
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.compositeSubscription.clear();
    }

    protected void verifyEmail(Uri data) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    protected void startSession(Uri data) {
        String email = data.getQueryParameter("email");
        if (email == null) {
            BridgeManagerProvider.getInstance().getAuthenticationManager().getEmail();
        }
        String token = data.getQueryParameter("token");
        this.compositeSubscription.add(BridgeManagerProvider.getInstance().getAuthenticationManager().signInViaEmailLink(email, token).observeOn(AndroidSchedulers.mainThread()).subscribe(session -> this.authSuccess(), this::authFailure));
    }

    protected void authFailure(Throwable t) {
        logger.warn("Failed to authenticated: ", t);
        String errorMsg = t.getLocalizedMessage();
        if (t instanceof UnknownHostException) {
            errorMsg = "Please check your network connection and try again.";
        }
        new AlertDialog.Builder((Context)this).setMessage((CharSequence)errorMsg).setCancelable(false).setPositiveButton((CharSequence)"Okay", (dialogInterface, i) -> this.finish()).create().show();
    }

    protected void authSuccess() {
        PackageManager pm = this.getPackageManager();
        Intent launchIntentForPackage = pm.getLaunchIntentForPackage(this.getPackageName());
        if (launchIntentForPackage != null) {
            launchIntentForPackage.addFlags(0x14000000);
            this.startActivity(launchIntentForPackage);
        }
        this.finish();
    }
}

