/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.bridge.android.di;

import android.content.Context;
import android.support.annotation.NonNull;
import dagger.BindsInstance;
import dagger.Component;
import javax.inject.Named;
import okhttp3.OkHttpClient;
import org.sagebionetworks.bridge.android.BridgeConfig;
import org.sagebionetworks.bridge.android.di.BridgeServiceModule;
import org.sagebionetworks.bridge.android.di.BridgeStudyScope;
import org.sagebionetworks.bridge.android.di.S3Module;
import org.sagebionetworks.bridge.android.manager.AppConfigManager;
import org.sagebionetworks.bridge.android.manager.dao.AccountDAO;
import org.sagebionetworks.bridge.android.manager.dao.ConsentDAO;
import org.sagebionetworks.bridge.android.manager.dao.UploadDAO;
import org.sagebionetworks.bridge.data.AndroidStudyUploadEncryptor;
import org.sagebionetworks.bridge.rest.ApiClientProvider;

@Component(modules={BridgeServiceModule.class, S3Module.class})
@BridgeStudyScope
public interface BridgeStudyComponent {
    @NonNull
    public AccountDAO getAccountDao();

    @NonNull
    public ApiClientProvider getApiClientProvider();

    @NonNull
    public AppConfigManager getAppConfigManager();

    @NonNull
    public BridgeConfig getBridgeConfig();

    @NonNull
    public ConsentDAO getConsentDao();

    @NonNull
    public UploadDAO getUploadDAO();

    @NonNull
    public AndroidStudyUploadEncryptor getStudyUploadEncryptor();

    @Named(value="s3OkHttp3Client")
    public OkHttpClient getS3OkHttp3Client();

    @Component.Builder
    public static interface Builder {
        @BindsInstance
        public Builder applicationContext(Context var1);

        public BridgeStudyComponent build();
    }
}

