/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.bridge.android.access;

import android.arch.lifecycle.MutableLiveData;
import android.arch.lifecycle.ViewModel;
import android.arch.lifecycle.ViewModelProvider;
import android.support.annotation.AnyThread;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.sagebionetworks.bridge.android.BridgeConfig;
import org.sagebionetworks.bridge.android.access.BridgeAccessState;
import org.sagebionetworks.bridge.android.access.Resource;
import org.sagebionetworks.bridge.android.manager.AuthenticationManager;
import org.sagebionetworks.bridge.android.receiver.AppVersionManager;
import org.sagebionetworks.bridge.rest.exceptions.EntityAlreadyExistsException;
import org.sagebionetworks.bridge.rest.model.SharingScope;
import org.sagebionetworks.bridge.rest.model.UserSessionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.subscriptions.CompositeSubscription;

public class BridgeAccessViewModel
extends ViewModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(BridgeAccessViewModel.class);
    private final AuthenticationManager authenticationManager;
    private final AppVersionManager appVersionManager;
    private final BridgeConfig bridgeConfig;
    private final CompositeSubscription compositeSubscription;
    private final MutableLiveData<Resource<BridgeAccessState>> bridgeAccessStatusMutableLiveData;

    public BridgeAccessViewModel(@NonNull AuthenticationManager authenticationManager, @NonNull AppVersionManager appVersionManager, @NonNull BridgeConfig bridgeConfig) {
        this.authenticationManager = (AuthenticationManager)Preconditions.checkNotNull((Object)authenticationManager);
        this.appVersionManager = (AppVersionManager)Preconditions.checkNotNull((Object)appVersionManager);
        this.bridgeConfig = (BridgeConfig)Preconditions.checkNotNull((Object)bridgeConfig);
        this.compositeSubscription = new CompositeSubscription();
        this.bridgeAccessStatusMutableLiveData = new MutableLiveData();
    }

    public void checkAccess() {
        this.checkAppVersion();
    }

    @VisibleForTesting
    void checkAppVersion() {
        this.bridgeAccessStatusMutableLiveData.postValue(Resource.loading(BridgeAccessState.REQUIRES_APP_UPGRADE));
        if (this.appVersionManager.isUpgradeRequired()) {
            this.bridgeAccessStatusMutableLiveData.postValue(Resource.success(BridgeAccessState.REQUIRES_APP_UPGRADE));
        } else {
            this.checkAuth();
        }
    }

    @VisibleForTesting
    void checkAuth() {
        UserSessionInfo userSessionInfo = this.authenticationManager.getUserSessionInfo();
        boolean authenticated = userSessionInfo != null && userSessionInfo.isAuthenticated() != false;
        this.bridgeAccessStatusMutableLiveData.postValue(Resource.loading(BridgeAccessState.REQUIRES_AUTHENTICATION));
        if (!authenticated) {
            this.bridgeAccessStatusMutableLiveData.postValue(Resource.success(BridgeAccessState.REQUIRES_AUTHENTICATION));
        } else {
            this.checkConsent();
        }
    }

    @VisibleForTesting
    void checkConsent() {
        boolean consented = this.authenticationManager.isConsented();
        this.bridgeAccessStatusMutableLiveData.postValue(Resource.loading(BridgeAccessState.REQUIRES_CONSENT));
        if (!consented) {
            this.bridgeAccessStatusMutableLiveData.postValue(Resource.success(BridgeAccessState.REQUIRES_CONSENT));
        } else {
            this.bridgeAccessStatusMutableLiveData.postValue(Resource.success(BridgeAccessState.ACCESS_GRANTED));
        }
    }

    @AnyThread
    public void consentsToResearch(@NonNull String participantName, @NonNull SharingScope sharingScope) {
        LOGGER.debug("consentsToResearch called");
        this.bridgeAccessStatusMutableLiveData.postValue(Resource.loading(BridgeAccessState.REQUIRES_CONSENT));
        this.compositeSubscription.add(this.authenticationManager.giveConsent(this.bridgeConfig.getStudyId(), participantName, null, null, null, sharingScope).subscribe(this::onConsentSuccess, this::onConsentFailure));
    }

    public MutableLiveData<Resource<BridgeAccessState>> getBridgeAccessStatus() {
        return this.bridgeAccessStatusMutableLiveData;
    }

    @VisibleForTesting
    void onConsentSuccess(UserSessionInfo userSessionInfo) {
        LOGGER.debug("consent upload success");
        this.bridgeAccessStatusMutableLiveData.postValue(Resource.success(BridgeAccessState.ACCESS_GRANTED));
    }

    @VisibleForTesting
    void onConsentFailure(Throwable t) {
        if (t instanceof EntityAlreadyExistsException) {
            LOGGER.warn("consent already exists");
            this.bridgeAccessStatusMutableLiveData.postValue(Resource.success(BridgeAccessState.ACCESS_GRANTED));
        } else {
            LOGGER.warn("consent upload error", t);
            this.bridgeAccessStatusMutableLiveData.postValue(Resource.error(t.getLocalizedMessage(), BridgeAccessState.REQUIRES_CONSENT));
        }
    }

    protected void onCleared() {
        super.onCleared();
        this.compositeSubscription.clear();
    }

    public static class Factory
    implements ViewModelProvider.Factory {
        private final AuthenticationManager authenticationManager;
        private final AppVersionManager appVersionManager;
        private final BridgeConfig bridgeConfig;

        @Inject
        public Factory(@NonNull AuthenticationManager authenticationManager, @NonNull AppVersionManager appVersionManager, @NonNull BridgeConfig bridgeConfig) {
            this.authenticationManager = (AuthenticationManager)Preconditions.checkNotNull((Object)authenticationManager);
            this.appVersionManager = (AppVersionManager)Preconditions.checkNotNull((Object)appVersionManager);
            this.bridgeConfig = (BridgeConfig)Preconditions.checkNotNull((Object)bridgeConfig);
        }

        @NonNull
        public <T extends ViewModel> T create(@NonNull Class<T> modelClass) {
            Preconditions.checkArgument((boolean)modelClass.isAssignableFrom(BridgeAccessViewModel.class));
            return (T)((Object)new BridgeAccessViewModel(this.authenticationManager, this.appVersionManager, this.bridgeConfig));
        }
    }
}

