/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.bridge.sdk.restmm.upload;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.sagebionetworks.bridge.sdk.restmm.upload.FileInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Info {
    public static final int BRIDGE_PHONE_INFO_LIMIT = 48;
    private static final Logger logger = LoggerFactory.getLogger(Info.class);
    private List<FileInfo> files;
    private String item;
    private String surveyGuid;
    private String surveyCreatedOn;
    private int schemaRevision = 1;
    private String appVersion;
    private String phoneInfo;

    public Info(Context context, String item, int schemaRevision) {
        this.item = item;
        this.schemaRevision = schemaRevision;
        this.files = new ArrayList<FileInfo>();
        this.initDetails(context);
    }

    public Info(Context context, String surveyGuid, String surveyCreatedOn) {
        this.surveyGuid = surveyGuid;
        this.surveyCreatedOn = surveyCreatedOn;
        this.files = new ArrayList<FileInfo>();
        this.initDetails(context);
    }

    private void initDetails(Context context) {
        String versionName;
        PackageManager manager = context.getPackageManager();
        try {
            PackageInfo info = manager.getPackageInfo(context.getPackageName(), 0);
            versionName = info.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            logger.error("Could not find package version info");
            versionName = "Unknown version";
        }
        String fullPhoneInfo = Build.MANUFACTURER + " " + Build.MODEL;
        this.phoneInfo = fullPhoneInfo.substring(0, Math.min(fullPhoneInfo.length(), 48));
        this.appVersion = versionName;
    }

    public void addFileInfo(FileInfo fileInfo) {
        this.files.add(fileInfo);
    }

    public String getFileName() {
        return UUID.randomUUID().toString() + "_" + (this.item == null ? this.surveyGuid : this.item) + ".zip";
    }
}

