/*
 * Decompiled with CFR 0.152.
 */
package org.sagebionetworks.bridge.android;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import org.sagebionetworks.bridge.android.R;

public class BridgeIdentifiers {
    private final Context applicationContext;

    public BridgeIdentifiers(Context applicationContext) {
        this.applicationContext = applicationContext;
    }

    public final String getUserAgent() {
        return this.getStudyName() + "/" + this.getAppVersion() + " (" + this.getDeviceName() + "; Android " + Build.VERSION.RELEASE + ") BridgeSDK/" + this.getSdkVersion();
    }

    public final int getSdkVersion() {
        return this.applicationContext.getResources().getInteger(R.integer.osb_android_sdk_version);
    }

    public String getStudyName() {
        return this.applicationContext.getResources().getString(R.string.osb_study_name);
    }

    public int getAppVersion() {
        return this.applicationContext.getResources().getInteger(R.integer.osb_app_version);
    }

    private String getDeviceName() {
        String model;
        String manufacturer = Build.MANUFACTURER;
        if (TextUtils.isEmpty((CharSequence)manufacturer)) {
            manufacturer = "Unknown";
        }
        if (TextUtils.isEmpty((CharSequence)(model = Build.MODEL))) {
            model = "Android";
        }
        if (model.startsWith(manufacturer)) {
            return this.capitalize(model);
        }
        return this.capitalize(manufacturer) + " " + model;
    }

    private String capitalize(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        char first = s.charAt(0);
        if (Character.isUpperCase(first)) {
            return s;
        }
        return Character.toUpperCase(first) + s.substring(1);
    }
}

