package org.sagebionetworks.bridge.sdk.restmm;

import java.util.Map;

public class UserSessionInfo {
  /**
   * User's username
   */
  private String username;

  /**
   * The users session token
   */
  private String sessionToken;

  /**
   * True if the user has consented to some form of data sharing; false otherwise (in other words,
   * false if sharingScope is set to "no_sharing")
   */
  private boolean dataSharing;

  /**
   * String representing the scope defined by possible values: <ul> <li><b>no_sharing</b> don't
   * share data generated by this participant</li> <li><b>sponsors_and_partners</b> share data in
   * data sets that are available to the study researchers and their researcher partners only</li>
   * <li><b>all_qualified_researchers</b> share data with researchers who qualify under the
   * specific
   * governance qualifications to access the study's data set.</li> </ul>
   */
  private String sharingScope;

  /**
   * Does the user currently consent to participate in the research study? This is true if, for all
   * the subpopulations that apply for this user, the user has consented (provide a signature for)
   * every consent that is required. Participants do not need to consent to optional consents and
   * their consents do not need to be up-to-date in order to be considered consented for the
   * purpose
   * of communicating with the Bridge server.
   */
  private boolean consented;

  /**
   * True if the the user currently authenticated
   */
  private boolean authenticated;

  /**
   * String representing the server environment defined by possible values: <ul> <li><b>local</b>
   * development only</li> <li><b>develop</b> again, development only, won't be seen in the
   * wild</li> <li><b>staging</b> the staging servers used to test studies and evaluate the Bridge
   * server before releasing an application in production</li> <li><b>production</b> the production
   * servers</li> </ul>
   */
  private String environment;

  /**
   * True if  all the required consents are signed and signed against an up-to-date version of the
   * consent.
   */
  private boolean signedMostRecentConsent;

  /**
   * An array of roles assigned to this user. Possibly values defined: <ul>
   * <li><b>administrator</b>
   * Bridge administrators. These are Sage employees and the API for these users is documented
   * separately.</li> <li><b>researcher</b> Researchers have rights to access study consents (to
   * add, edit and delete them, as well as publish them), and they have the right to view study
   * participant information. Users with the researcher role will be granted developer privileges
   * as
   * well .</li> <li><b>developer</b> Developers have the right to edit studies, upload schemas,
   * surveys, and schedules. They have complete control over a study's configuration, but they do
   * not have access to the consents or to information about participants in a study. Researchers
   * will be given developer privileges as well as the researcher role.</li> <li><b>consented
   * users</b> Any participant in a study who has consented to research.</li> <li><b>all users</b>
   * A
   * publicly-accessible endpoint. No role required.</li> </ul>
   */
  private String[] roles;

  /**
   * An array of any data groups that have been assigned to this user. These are defined by a user
   * with developer role
   */
  private String[] dataGroups;

  /**
   * Detailed information about all consents that apply to this user due to their assignment into
   * one or more study subpopulations. A map of object property/ConsentStatus object pairs, where
   * each property is the GUID of a subpopulation, and each consent status object is the consent
   * status for that subpopulation.
   */
  private Map<String, ConsentStatus> consentStatuses;

  public Map<String, ConsentStatus> getConsentStatuses() {
    return consentStatuses;
  }

  public void setConsentStatuses(Map<String, ConsentStatus> consentStatuses) {
    this.consentStatuses = consentStatuses;
  }

  public String getUsername() {
    return username;
  }

  public void setUsername(String username) {
    this.username = username;
  }

  public String getSessionToken() {
    return sessionToken;
  }

  public void setSessionToken(String sessionToken) {
    this.sessionToken = sessionToken;
  }

  public boolean isDataSharing() {
    return dataSharing;
  }

  public void setDataSharing(boolean dataSharing) {
    this.dataSharing = dataSharing;
  }

  public String getSharingScope() {
    return sharingScope;
  }

  public void setSharingScope(String sharingScope) {
    this.sharingScope = sharingScope;
  }

  public boolean isConsented() {
    return consented;
  }

  public void setConsented(boolean consented) {
    this.consented = consented;
  }

  public boolean isAuthenticated() {
    return authenticated;
  }

  public void setAuthenticated(boolean authenticated) {
    this.authenticated = authenticated;
  }

  public String getEnvironment() {
    return environment;
  }

  public void setEnvironment(String environment) {
    this.environment = environment;
  }

  public boolean isSignedMostRecentConsent() {
    return signedMostRecentConsent;
  }

  public void setSignedMostRecentConsent(boolean signedMostRecentConsent) {
    this.signedMostRecentConsent = signedMostRecentConsent;
  }

  public String[] getRoles() {
    return roles;
  }

  public void setRoles(String[] roles) {
    this.roles = roles;
  }

  public String[] getDataGroups() {
    return dataGroups;
  }

  public void setDataGroups(String[] dataGroups) {
    this.dataGroups = dataGroups;
  }

  /**
   * The consented and signedMostRecentConsent flags in the user's session give the general state
   * of
   * the account in the study; the consent statuses provide a detailed breakdown of all consents
   * that apply to a participant based upon the subpopulations that apply to the participant. <p>
   * When a client application receives a 412, the JSON payload also includes a session that will
   * include this information. At a minimum, the user will need to be presented with each required
   * consent and given an opportunity to sign each one in turn. Optional consents can also be shown
   * and may change the behavior of the client application, so it may also be necessary to examine
   * this collection for application behavior as well. Optional consents can be marked declined, so
   * that in the future, the app will know not to present UI around a request to participate in
   * that
   * aspect of the study. <p> For example, an optional consent might ask if the participant is
   * willing to donate genetic information to the study. If agreed to, the app might present a new
   * tab with information on how to do that. If declined, the application can prevent this request
   * from being made in the future.
   */
  public static class ConsentStatus {

    /**
     * The GUID for the subpopulation of this consent
     */
    private String subpopulationGuid;

    /**
     * The name of the subpopulation
     */
    private String name;

    /**
     * Is this consent required? If required, the user must consent to it before being given access
     * to the server (until signed, a 412 response is returned from the server).
     */
    private boolean required;

    /**
     * Has the participant consented to this consent agreement?
     */
    private boolean consented;

    /**
     * True if  the consent to participate made against the most recently published version of this
     * consent
     */
    private boolean signedMostRecentConsent;

    public String getSubpopulationGuid() {
      return subpopulationGuid;
    }

    public void setSubpopulationGuid(String subpopulationGuid) {
      this.subpopulationGuid = subpopulationGuid;
    }

    public String getName() {
      return name;
    }

    public void setName(String name) {
      this.name = name;
    }

    public boolean isRequired() {
      return required;
    }

    public void setRequired(boolean required) {
      this.required = required;
    }

    public boolean isConsented() {
      return consented;
    }

    public void setConsented(boolean consented) {
      this.consented = consented;
    }

    public boolean isSignedMostRecentConsent() {
      return signedMostRecentConsent;
    }

    public void setSignedMostRecentConsent(boolean signedMostRecentConsent) {
      this.signedMostRecentConsent = signedMostRecentConsent;
    }
  }
}
