/*
 * Decompiled with CFR 0.152.
 */
package org.sadtech.vk.bot.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sadtech.autoresponder.repository.UnitPointerRepository;
import org.sadtech.autoresponder.repository.UnitPointerRepositoryMap;
import org.sadtech.social.bot.domain.unit.MainUnit;
import org.sadtech.social.core.repository.ContentRepository;
import org.sadtech.social.core.repository.impl.local.MailRepositoryList;
import org.sadtech.social.core.service.MailService;
import org.sadtech.social.core.service.MessageService;
import org.sadtech.social.core.service.impl.MailServiceImpl;
import org.sadtech.social.core.service.sender.Sending;
import org.sadtech.vk.bot.sdk.MessageAutoresponderVk;
import org.sadtech.vk.bot.sdk.config.VkConfig;
import org.sadtech.vk.bot.sdk.config.VkConfigGroup;
import org.sadtech.vk.bot.sdk.config.VkConfigService;
import org.sadtech.vk.bot.sdk.config.VkConnect;
import org.sadtech.vk.bot.sdk.repository.RawEventRepository;
import org.sadtech.vk.bot.sdk.repository.impl.RawEventRepositorySet;
import org.sadtech.vk.bot.sdk.sender.MailSenderVk;
import org.sadtech.vk.bot.sdk.service.RawEventService;
import org.sadtech.vk.bot.sdk.service.distribution.EventDistributor;
import org.sadtech.vk.bot.sdk.service.distribution.subscriber.MailSubscriber;
import org.sadtech.vk.bot.sdk.service.impl.RawEventServiceImpl;
import org.sadtech.vk.bot.sdk.service.listener.EventListenerVk;
import org.sadtech.vk.bot.sdk.utils.VkApi;
import org.sadtech.vk.bot.utils.UnitUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@Configuration
@EnableScheduling
public class BeanConfig {
    @Bean
    public ConversionService conversionService(Converter ... converters) {
        DefaultConversionService defaultConversionService = new DefaultConversionService();
        Arrays.stream(converters).forEach(arg_0 -> ((DefaultConversionService)defaultConversionService).addConverter(arg_0));
        return defaultConversionService;
    }

    @Bean
    public TaskScheduler taskScheduler() {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        taskScheduler.setPoolSize(3);
        return taskScheduler;
    }

    @Bean
    public VkConfig vkConfig(VkConfigGroup vkConfigGroup, VkConfigService vkConfigService) {
        return VkConfig.builder().configGroup(vkConfigGroup).configService(vkConfigService).build();
    }

    @Bean
    public VkConnect vkConnect(VkConfig vkConfig) {
        return new VkConnect(vkConfig);
    }

    @Bean(name={"menuUnits"})
    public Set<MainUnit> startUnit(ListableBeanFactory listableBeanFactory) {
        Collection units = listableBeanFactory.getBeansOfType(MainUnit.class).entrySet().stream().filter(stringMainUnitEntry -> !((String)stringMainUnitEntry.getKey()).equalsIgnoreCase("defaultunit")).map(Map.Entry::getValue).collect(Collectors.toSet());
        Set nextUnitId = units.stream().flatMap(unit -> UnitUtils.nextUnits(unit).stream()).distinct().map(MainUnit::getUuid).collect(Collectors.toSet());
        return units.stream().filter(mainUnit -> !nextUnitId.contains(mainUnit.getUuid())).collect(Collectors.toSet());
    }

    @Bean
    public MessageAutoresponderVk messageAutoresponderVk(@Qualifier(value="menuUnits") Set<MainUnit> startUnit, Sending sending, MailService mailService, UnitPointerRepository unitPointerRepository, MainUnit defaultUnit) {
        MessageAutoresponderVk messageAutoresponderVk = new MessageAutoresponderVk(startUnit, sending, (MessageService)mailService, unitPointerRepository);
        messageAutoresponderVk.setDefaultUnit(defaultUnit);
        return messageAutoresponderVk;
    }

    @Bean
    public UnitPointerRepository unitPointerRepository() {
        return new UnitPointerRepositoryMap();
    }

    @Bean
    public Sending sending(VkConnect vkConnect, ConversionService conversionService) {
        MailSenderVk mailSenderVk = new MailSenderVk(vkConnect);
        mailSenderVk.setConversionService(conversionService);
        return mailSenderVk;
    }

    @Bean
    public MailService mailService() {
        return new MailServiceImpl((ContentRepository)new MailRepositoryList());
    }

    @Bean
    public RawEventService rawEventService() {
        return new RawEventServiceImpl((RawEventRepository)new RawEventRepositorySet());
    }

    @Bean
    public EventListenerVk eventListenerVk(VkConnect vkConnect, RawEventService rawEventService) {
        return new EventListenerVk(vkConnect, rawEventService);
    }

    @Bean
    public EventDistributor eventDistributor(RawEventService rawEventService, MailService mailService, ConversionService conversionService) {
        MailSubscriber mailSubscriber = new MailSubscriber(mailService, conversionService);
        return new EventDistributor(rawEventService, Collections.singleton(mailSubscriber));
    }

    @Bean
    public VkApi vkApi(VkConnect vkConnect) {
        return new VkApi(vkConnect);
    }
}

