/*
 * Decompiled with CFR 0.152.
 */
package org.rypt.f8;

import java.io.OutputStream;
import org.rypt.f8.Utf8;
import org.rypt.f8.Utf8Handler;

public class Utf8Statistics
extends OutputStream
implements Utf8Handler<RuntimeException> {
    private int state;
    private long numAscii;
    private long num2byte;
    private long num3byte;
    private long num4byte;
    private long numTruncated;
    private long numError;

    public void reset() {
        this.state = 0;
        this.numAscii = 0L;
        this.num2byte = 0L;
        this.num3byte = 0L;
        this.num4byte = 0L;
        this.numTruncated = 0L;
        this.numError = 0L;
    }

    @Override
    public void write(int b) {
        this.state = Utf8.nextState(this.state, (byte)b, this);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.state = Utf8.nextState(this.state, b, off, off + len, this);
    }

    @Override
    public void write(byte[] b) {
        this.state = Utf8.nextState(this.state, b, 0, b.length, this);
    }

    @Override
    public void close() {
        Utf8.finish(this.state, this);
        this.state = 0;
    }

    @Override
    public void handleError() {
        ++this.numError;
    }

    @Override
    public void handleContinuationError(int b1, int b2, int b3, int nextByte) {
        if (nextByte == -257) {
            ++this.numTruncated;
        }
        this.handleError();
    }

    @Override
    public void handleContinuationError(int b1, int b2, int nextByte) {
        if (nextByte == -257) {
            ++this.numTruncated;
        }
        this.handleError();
    }

    @Override
    public void handleContinuationError(int b1, int nextByte) {
        if (nextByte == -257) {
            ++this.numTruncated;
        }
        this.handleError();
    }

    @Override
    public void handleCodePoint(int codePoint) {
        if (codePoint > 65535) {
            ++this.num4byte;
        } else if (codePoint > 2047) {
            ++this.num3byte;
        } else if (codePoint > 127) {
            ++this.num2byte;
        } else {
            ++this.numAscii;
        }
    }

    @Override
    public void handle1ByteCodePoint(int ascii) {
        ++this.numAscii;
    }

    @Override
    public void handle2ByteCodePoint(int b1, int b2) {
        ++this.num2byte;
    }

    @Override
    public void handle3ByteCodePoint(int b1, int b2, int b3) {
        ++this.num3byte;
    }

    @Override
    public void handle4ByteCodePoint(int b1, int b2, int b3, int b4) {
        ++this.num4byte;
    }

    public long countCodePoints() {
        return this.numAscii + this.num2byte + this.num3byte + this.num4byte;
    }

    @Deprecated
    public long countValid() {
        return this.countCodePoints() - this.numAscii;
    }

    public long countInvalid() {
        return this.numError;
    }

    public long countInvalidIgnoringTruncation() {
        return this.numError - this.numTruncated;
    }

    public long countAscii() {
        return this.numAscii;
    }

    public long count2Byte() {
        return this.num2byte;
    }

    public long count3Byte() {
        return this.num3byte;
    }

    public long count4Byte() {
        return this.num4byte;
    }

    public boolean looksLikeUtf8() {
        return this.count2Byte() + this.count3Byte() + this.count4Byte() > this.countInvalidIgnoringTruncation() * 10L;
    }

    public String toString() {
        return "state=0x" + Integer.toHexString(this.state) + "; ascii=" + this.numAscii + "; 2-byte=" + this.num2byte + "; 3-byte=" + this.num3byte + "; 4-byte=" + this.num4byte + "; error=" + this.numError + (this.numTruncated != 0L ? " (was truncated)" : "");
    }
}

