/*
 * Decompiled with CFR 0.152.
 */
package org.rypt.f8;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReference;
import org.rypt.f8.Utf8ByteHandler;
import org.rypt.f8.Validity;
import org.rypt.f8.__;

public class Utf8 {
    static final int SURROGATE_PREFIX = -1;
    private static final int OTHER_ERROR = -2;
    private static final int BUFFER_SIZE = 8192;
    private static final AtomicReference<byte[]> buf = new AtomicReference();

    private Utf8() {
        throw new AssertionError();
    }

    @Deprecated
    public static int nextState(int s, byte b) {
        int z = s + 2;
        if ((z & b + 64) >= 0) {
            if ((z | b & (b - -62 | -12 - b)) >= 0) {
                return b;
            }
            return -2;
        }
        if (s >> 5 == -2) {
            return Utf8.codePoint(s, b);
        }
        if (s >= -4096) {
            if ((s & 0xFB) == 240 && (s << 28) + 112 + b >> 30 != 0 || s == -32 && b < -96) {
                return -2;
            }
            int c = s << 8 | b & 0xFF;
            return c >> 5 == -147 ? -1 : c;
        }
        if (s >> 12 == -2) {
            return Utf8.codePoint(s >> 8, (byte)s, b);
        }
        return Utf8.codePoint(s >> 16, (byte)(s >> 8), (byte)s, b);
    }

    private static <X extends Exception> void transferState(int s, int nextByte, Utf8ByteHandler<X> handler) throws X {
        if (Utf8.isIncompleteState(s)) {
            if (s >= -64) {
                handler.handleContinuationError(s, nextByte);
            } else if (s >= -8192) {
                handler.handleContinuationError(s >> 8, (byte)s, nextByte);
            } else {
                handler.handleContinuationError(s >> 16, (byte)(s >> 8), (byte)s, nextByte);
            }
        }
    }

    public static <X extends Exception> int nextState(int s, byte b, Utf8ByteHandler<X> handler) throws X {
        if (s >= -2 || b >= -64) {
            Utf8.transferState(s, b, handler);
            if (b >= 0) {
                handler.handle1ByteCodePoint(b);
                return 0;
            }
            if (b >= -62 && b <= -12) {
                return b;
            }
            if (Utf8.isSurrogatePrefixErrorState(s) && b < -64) {
                handler.handleIgnoredByte(b);
                return 0;
            }
            handler.handlePrefixError(b);
            return 0;
        }
        if (s >> 5 == -2) {
            handler.handle2ByteCodePoint(s, b);
            return 0;
        }
        if (s >> 12 == -2) {
            handler.handle3ByteCodePoint(s >> 8, (byte)s, b);
            return 0;
        }
        if (s >> 19 == -2) {
            handler.handle4ByteCodePoint(s >> 16, (byte)(s >> 8), (byte)s, b);
            return 0;
        }
        if ((s & 0xFB) == 240 && (s << 28) + 112 + b >> 30 != 0 || s == -32 && b < -96) {
            handler.handleContinuationError(s, b);
            handler.handlePrefixError(b);
            return 0;
        }
        int c = s << 8 | b & 0xFF;
        if (c >> 5 == -147) {
            handler.handleContinuationError(-19, b);
            handler.handleIgnoredByte(b);
            return -1;
        }
        return c;
    }

    public static <X extends Exception> int nextState(int state, byte[] b, int from, int to, Utf8ByteHandler<X> handler) throws X {
        byte n;
        if (from >= to) {
            if (from > to) {
                throw new IllegalArgumentException(from + " > " + to);
            }
            return state;
        }
        if (state < 0) {
            do {
                n = b[from++];
                state = Utf8.nextState(state, n, handler);
                if (from != to) continue;
                return state;
            } while (state != 0 && state != n);
            from += state >> 31;
        }
        do {
            if ((n = b[from++]) < 0) {
                return __.state(b, from - 1, to, handler);
            }
            handler.handle1ByteCodePoint(n);
        } while (from != to);
        return 0;
    }

    public static <X extends Exception> int nextState(int state, InputStream inputStream, Utf8ByteHandler<X> handler) throws IOException, X {
        int n;
        AtomicReference<byte[]> buf = Utf8.buf;
        byte[] bytes = buf.get();
        if (bytes == null || !buf.compareAndSet(bytes, null)) {
            bytes = new byte[8192];
        }
        while ((n = inputStream.read(bytes, 0, 8192)) != -1) {
            state = Utf8.nextState(state, bytes, 0, n, handler);
        }
        buf.set(bytes);
        return state;
    }

    public static <X extends Exception> void finish(int finalState, Utf8ByteHandler<X> handler) throws X {
        Utf8.transferState(finalState, -257, handler);
    }

    public static <X extends Exception> void transfer(InputStream is, Utf8ByteHandler<X> handler) throws IOException, X {
        Utf8.finish(Utf8.nextState(0, is, handler), handler);
    }

    public static Validity validity(InputStream is) throws IOException {
        int n;
        AtomicReference<byte[]> buf = Utf8.buf;
        byte[] b = buf.get();
        if (b == null || !buf.compareAndSet(b, null)) {
            b = new byte[8192];
        }
        while ((n = is.read(b, 0, 8192)) >= 0) {
            for (int i = 0; i < n; ++i) {
                if (b[i] >= 0) continue;
                Validity v = __.validity(b, i, n);
                while (v != Validity.MALFORMED) {
                    int r = 0;
                    switch (v) {
                        case UNDERFLOW_R3: {
                            b[r++] = b[n - 3];
                        }
                        case UNDERFLOW_R2: {
                            b[r++] = b[n - 2];
                        }
                        case UNDERFLOW_R1: {
                            b[r++] = b[n - 1];
                        }
                    }
                    n = is.read(b, r, 8192 - r);
                    if (n < 0) {
                        buf.set(b);
                        return v;
                    }
                    v = __.validity(b, 0, n += r);
                }
                buf.set(b);
                return Validity.MALFORMED;
            }
        }
        buf.set(b);
        return Validity.ASCII;
    }

    public static Validity validity(byte[] b, int from, int to) {
        if (from > to) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        for (int i = from; i < to; ++i) {
            if (b[i] >= 0) continue;
            return __.validity(b, i, to);
        }
        return Validity.ASCII;
    }

    public static int codePoint(int b1, int b2) {
        return b1 << 6 ^ b2 ^ 0xF80;
    }

    public static int codePoint(int b1, int b2, int b3) {
        return b1 << 12 ^ b2 << 6 ^ b3 ^ 0xFFFE1F80;
    }

    public static int codePoint(int b1, int b2, int b3, int b4) {
        return b1 << 18 ^ b2 << 12 ^ b3 << 6 ^ b4 ^ 0x381F80;
    }

    public static boolean isIncompleteState(int s) {
        return s < -2;
    }

    public static boolean isErrorState(int s) {
        return s >> 1 == -1;
    }

    public static boolean isSurrogatePrefixErrorState(int s) {
        return s == -1;
    }
}

