/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;

public class Util {
    public static int getJavaVersion() {
        String version = System.getProperty("java.version");
        assert (version != null);
        if (version.startsWith("1.")) {
            version = version.substring(2);
        }
        int dotPos = version.indexOf(46);
        int dashPos = version.indexOf(45);
        return Integer.parseInt(version.substring(0, dotPos > -1 ? dotPos : (dashPos > -1 ? dashPos : version.length())));
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        try {
            in.transferTo(out);
        }
        finally {
            in.close();
        }
    }

    public static byte[] readBytes(InputStream is) throws IOException {
        try {
            byte[] byArray = is.readAllBytes();
            return byArray;
        }
        finally {
            is.close();
        }
    }

    public static <T> T[] reverse(T[] array) {
        for (int i = 0; i < array.length / 2; ++i) {
            int destI = array.length - i - 1;
            T o = array[destI];
            array[destI] = array[i];
            array[i] = o;
        }
        return array;
    }

    public static Path pathFrom(URL localArtifactUrl) {
        try {
            return Paths.get(localArtifactUrl.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("huh? " + localArtifactUrl, e);
        }
    }

    public static <T extends Throwable> RuntimeException sneakyThrow(Throwable t) throws T {
        throw t;
    }
}

