/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.util.reflector;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.ReflectorClassWriter;
import org.robolectric.util.reflector.UnsafeAccess;
import org.robolectric.util.reflector.WeakerHashMap;

public class Reflector {
    private static final boolean DEBUG = false;
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private static final Map<Class<?>, Constructor<?>> CACHE = Collections.synchronizedMap(new WeakerHashMap());

    public static <T> T reflector(Class<T> iClass) {
        return Reflector.reflector(iClass, null);
    }

    public static <T> T reflector(Class<T> iClass, Object target) {
        Class<?> targetClass = Reflector.determineTargetClass(iClass);
        Constructor<Object> ctor = CACHE.get(iClass);
        try {
            if (ctor == null) {
                Class<T> reflectorClass = Reflector.createReflectorClass(iClass, targetClass);
                ctor = reflectorClass.getConstructor(targetClass);
                ctor.setAccessible(true);
            }
            CACHE.put(iClass, ctor);
            return (T)ctor.newInstance(target);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private static <T> Class<?> determineTargetClass(Class<T> iClass) {
        ForType forType = iClass.getAnnotation(ForType.class);
        if (forType == null) {
            throw new IllegalArgumentException("no @ForType annotation found for " + iClass);
        }
        Class<?> targetClass = forType.value();
        if (targetClass.equals(Void.TYPE)) {
            String forClassName = forType.className();
            if (forClassName.isEmpty()) {
                throw new IllegalArgumentException("no value or className given for @ForType for " + iClass);
            }
            try {
                targetClass = Class.forName(forClassName, false, iClass.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("failed to resolve @ForType class for " + iClass, e);
            }
        }
        return targetClass;
    }

    private static <T> Class<? extends T> createReflectorClass(Class<T> iClass, Class<?> targetClass) {
        String reflectorClassName = iClass.getName() + "$$Reflector" + COUNTER.getAndIncrement();
        byte[] bytecode = Reflector.getBytecode(iClass, targetClass, reflectorClassName);
        Class<?> proxyClass = Reflector.defineViaUnsafe(iClass, reflectorClassName, bytecode);
        return proxyClass.asSubclass(iClass);
    }

    private static <T> Class<?> defineViaUnsafe(Class<T> iClass, String reflectorClassName, byte[] bytecode) {
        return UnsafeAccess.defineClass(iClass, reflectorClassName, bytecode);
    }

    private static <T> Class<?> defineViaNewClassLoader(Class<T> iClass, String reflectorClassName, final byte[] bytecode) {
        Class<?> proxyClass;
        ClassLoader classLoader = new ClassLoader(iClass.getClassLoader()){

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                return this.defineClass(name, bytecode, 0, bytecode.length);
            }
        };
        try {
            proxyClass = classLoader.loadClass(reflectorClassName);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        return proxyClass;
    }

    private static <T> byte[] getBytecode(Class<T> iClass, Class<?> targetClass, String reflectorClassName) {
        ReflectorClassWriter writer = new ReflectorClassWriter(iClass, targetClass, reflectorClassName);
        writer.write();
        return writer.toByteArray();
    }
}

