package org.robolectric.shadows.gms;
import com.google.android.gms.auth.GoogleAuthUtil;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.GooglePlayServicesUtil;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import org.robolectric.internal.ShadowProvider;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.gms.ShadowGoogleAuthUtil;
import org.robolectric.shadows.gms.ShadowGooglePlayServicesUtil;
import org.robolectric.shadows.gms.common.ShadowGoogleApiAvailability;

/**
 * Shadow mapper. Automatically generated by the Robolectric Annotation Processor.
 */
@Generated("org.robolectric.annotation.processing.RobolectricProcessor")
@SuppressWarnings({"unchecked","deprecation"})
public class Shadows implements ShadowProvider {
  private static final Map<String, String> SHADOW_MAP = new HashMap<>(3);

  static {
    SHADOW_MAP.put("com.google.android.gms.auth.GoogleAuthUtil", "org.robolectric.shadows.gms.ShadowGoogleAuthUtil");
    SHADOW_MAP.put("com.google.android.gms.common.GooglePlayServicesUtil", "org.robolectric.shadows.gms.ShadowGooglePlayServicesUtil");
    SHADOW_MAP.put("com.google.android.gms.common.GoogleApiAvailability", "org.robolectric.shadows.gms.common.ShadowGoogleApiAvailability");
  }

  public static ShadowGoogleAuthUtil shadowOf(GoogleAuthUtil actual) {
    return (ShadowGoogleAuthUtil) Shadow.extract(actual);
  }

  public static ShadowGooglePlayServicesUtil shadowOf(GooglePlayServicesUtil actual) {
    return (ShadowGooglePlayServicesUtil) Shadow.extract(actual);
  }

  public static ShadowGoogleApiAvailability shadowOf(GoogleApiAvailability actual) {
    return (ShadowGoogleApiAvailability) Shadow.extract(actual);
  }

  @Override
  public void reset() {
    ShadowGoogleAuthUtil.reset();
    ShadowGooglePlayServicesUtil.reset();
  }

  @Override
  public Map<String, String> getShadowMap() {
    return SHADOW_MAP;
  }

  @Override
  public String[] getProvidedPackageNames() {
    return new String[] {
      "com.google.android.gms.auth",
      "com.google.android.gms.common"
    };
  }

}
