/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.drawable.VectorDrawable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.ShadowDrawable;
import org.robolectric.shadows.ShadowVirtualRefBasePtr;

@Implements(value=VectorDrawable.class, minSdk=24)
public class ShadowVectorDrawable
extends ShadowDrawable {
    private static final int STROKE_WIDTH_INDEX = 0;
    private static final int STROKE_COLOR_INDEX = 1;
    private static final int STROKE_ALPHA_INDEX = 2;
    private static final int FILL_COLOR_INDEX = 3;
    private static final int FILL_ALPHA_INDEX = 4;
    private static final int TRIM_PATH_START_INDEX = 5;
    private static final int TRIM_PATH_END_INDEX = 6;
    private static final int TRIM_PATH_OFFSET_INDEX = 7;
    private static final int STROKE_LINE_CAP_INDEX = 8;
    private static final int STROKE_LINE_JOIN_INDEX = 9;
    private static final int STROKE_MITER_LIMIT_INDEX = 10;
    private static final int FILL_TYPE_INDEX = 11;
    private static final int TOTAL_PROPERTY_COUNT = 12;

    private static Path getPath(long pathPtr) {
        return ShadowVirtualRefBasePtr.get(pathPtr, Path.class);
    }

    @Implementation
    protected static long nCreateFullPath() {
        return ShadowVirtualRefBasePtr.put(new Path());
    }

    @Implementation
    protected static long nCreateFullPath(long nativeFullPathPtr) {
        return ShadowVirtualRefBasePtr.put(ShadowVectorDrawable.getPath(nativeFullPathPtr).clone());
    }

    @Implementation
    protected static boolean nGetFullPathProperties(long pathPtr, byte[] properties, int length) {
        if (length != 48) {
            return false;
        }
        Path path = ShadowVectorDrawable.getPath(pathPtr);
        ByteBuffer propertiesBB = ByteBuffer.wrap(properties);
        propertiesBB.order(ByteOrder.nativeOrder());
        propertiesBB.putFloat(0, path.strokeWidth);
        propertiesBB.putInt(4, path.strokeColor);
        propertiesBB.putFloat(8, path.strokeAlpha);
        propertiesBB.putInt(12, path.fillColor);
        propertiesBB.putFloat(16, path.fillAlpha);
        propertiesBB.putFloat(20, path.trimPathStart);
        propertiesBB.putFloat(24, path.trimPathEnd);
        propertiesBB.putFloat(28, path.trimPathOffset);
        propertiesBB.putInt(32, path.strokeLineCap);
        propertiesBB.putInt(36, path.strokeLineJoin);
        propertiesBB.putFloat(40, path.strokeMiterLimit);
        propertiesBB.putInt(44, path.fillType);
        return true;
    }

    @Implementation
    protected static void nUpdateFullPathProperties(long pathPtr, float strokeWidth, int strokeColor, float strokeAlpha, int fillColor, float fillAlpha, float trimPathStart, float trimPathEnd, float trimPathOffset, float strokeMiterLimit, int strokeLineCap, int strokeLineJoin, int fillType) {
        Path path = ShadowVectorDrawable.getPath(pathPtr);
        path.strokeWidth = strokeWidth;
        path.strokeColor = strokeColor;
        path.strokeAlpha = strokeAlpha;
        path.fillColor = fillColor;
        path.fillAlpha = fillAlpha;
        path.trimPathStart = trimPathStart;
        path.trimPathEnd = trimPathEnd;
        path.trimPathOffset = trimPathOffset;
        path.strokeLineCap = strokeLineCap;
        path.strokeLineJoin = strokeLineJoin;
        path.strokeMiterLimit = strokeMiterLimit;
        path.fillType = fillType;
    }

    private static Group getGroup(long groupPtr) {
        return ShadowVirtualRefBasePtr.get(groupPtr, Group.class);
    }

    @Implementation
    protected static long nCreateGroup() {
        return ShadowVirtualRefBasePtr.put(new Group());
    }

    @Implementation
    protected static long nCreateGroup(long groupPtr) {
        return ShadowVirtualRefBasePtr.put(ShadowVectorDrawable.getGroup(groupPtr).clone());
    }

    @Implementation
    protected static boolean nGetGroupProperties(long groupPtr, float[] properties, int length) {
        if (length != 7) {
            return false;
        }
        Group group = ShadowVectorDrawable.getGroup(groupPtr);
        properties[0] = group.rotation;
        properties[1] = group.pivotX;
        properties[2] = group.pivotY;
        properties[3] = group.scaleX;
        properties[4] = group.scaleY;
        properties[5] = group.translateX;
        properties[6] = group.translateY;
        return true;
    }

    @Implementation
    protected static void nUpdateGroupProperties(long groupPtr, float rotate, float pivotX, float pivotY, float scaleX, float scaleY, float translateX, float translateY) {
        Group group = ShadowVectorDrawable.getGroup(groupPtr);
        group.rotation = rotate;
        group.pivotX = pivotX;
        group.pivotY = pivotY;
        group.scaleX = scaleX;
        group.scaleY = scaleY;
        group.translateX = translateX;
        group.translateY = translateY;
    }

    static class Group
    implements Cloneable {
        float rotation;
        float pivotX;
        float pivotY;
        float scaleX;
        float scaleY;
        float translateX;
        float translateY;

        Group() {
        }

        protected Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class Path
    implements Cloneable {
        float strokeWidth;
        int strokeColor;
        float strokeAlpha;
        int fillColor;
        float fillAlpha;
        float trimPathStart;
        float trimPathEnd;
        float trimPathOffset;
        int strokeLineCap;
        int strokeLineJoin;
        float strokeMiterLimit;
        int fillType;

        private Path() {
        }

        protected Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

