/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.speech.tts.TextToSpeech;
import android.speech.tts.UtteranceProgressListener;
import java.util.HashMap;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=TextToSpeech.class)
public class ShadowTextToSpeech {
    @RealObject
    private TextToSpeech tts;
    private Context context;
    private TextToSpeech.OnInitListener listener;
    private String lastSpokenText;
    private boolean shutdown = false;
    private boolean stopped = true;
    private int queueMode = -1;

    @Implementation
    protected void __constructor__(Context context, TextToSpeech.OnInitListener listener) {
        this.context = context;
        this.listener = listener;
    }

    @Implementation
    protected int speak(String text, int queueMode, HashMap<String, String> params) {
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            return ((TextToSpeech)Shadow.directlyOn((Object)this.tts, TextToSpeech.class)).speak(text, queueMode, params);
        }
        return this.speak(text, queueMode, null, params == null ? null : params.get("utteranceId"));
    }

    @Implementation(minSdk=21)
    protected int speak(CharSequence text, int queueMode, Bundle params, String utteranceId) {
        this.stopped = false;
        this.lastSpokenText = text.toString();
        this.queueMode = queueMode;
        if (RuntimeEnvironment.getApiLevel() >= 15 && utteranceId != null) {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(() -> {
                UtteranceProgressListener utteranceProgressListener = this.getUtteranceProgressListener();
                if (utteranceProgressListener != null) {
                    utteranceProgressListener.onStart(utteranceId);
                }
                handler.post(() -> {
                    UtteranceProgressListener utteranceProgressListener2 = this.getUtteranceProgressListener();
                    if (utteranceProgressListener2 != null) {
                        utteranceProgressListener2.onDone(utteranceId);
                    }
                });
            });
        }
        return 0;
    }

    @Implementation
    protected void shutdown() {
        this.shutdown = true;
    }

    @Implementation
    protected int stop() {
        this.stopped = true;
        return 0;
    }

    private UtteranceProgressListener getUtteranceProgressListener() {
        return (UtteranceProgressListener)ReflectionHelpers.getField((Object)this.tts, (String)"mUtteranceProgressListener");
    }

    public Context getContext() {
        return this.context;
    }

    public TextToSpeech.OnInitListener getOnInitListener() {
        return this.listener;
    }

    public String getLastSpokenText() {
        return this.lastSpokenText;
    }

    public void clearLastSpokenText() {
        this.lastSpokenText = null;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public int getQueueMode() {
        return this.queueMode;
    }
}

