/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.hardware.Sensor;
import android.hardware.SensorDirectChannel;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.MemoryFile;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=SensorManager.class, looseSignatures=true)
public class ShadowSensorManager {
    public boolean forceListenersToFail = false;
    private final Map<Integer, Sensor> sensorMap = new HashMap<Integer, Sensor>();
    private final List<SensorEventListener> listeners = new CopyOnWriteArrayList<SensorEventListener>();
    @RealObject
    private SensorManager realObject;

    @Deprecated
    public void addSensor(int sensorType, Sensor sensor) {
        this.sensorMap.put(sensorType, sensor);
    }

    public void addSensor(Sensor sensor) {
        this.sensorMap.put(sensor.getType(), sensor);
    }

    @Implementation
    protected Sensor getDefaultSensor(int type) {
        return this.sensorMap.get(type);
    }

    @Implementation
    public List<Sensor> getSensorList(int type) {
        ArrayList<Sensor> sensorList = new ArrayList<Sensor>();
        Sensor sensor = this.sensorMap.get(type);
        if (sensor != null) {
            sensorList.add(sensor);
        }
        return sensorList;
    }

    @Implementation
    protected boolean registerListener(SensorEventListener listener, Sensor sensor, int rate, Handler handler) {
        return this.registerListener(listener, sensor, rate);
    }

    @Implementation
    protected boolean registerListener(SensorEventListener listener, Sensor sensor, int rate, int maxLatency) {
        return this.registerListener(listener, sensor, rate);
    }

    @Implementation
    protected boolean registerListener(SensorEventListener listener, Sensor sensor, int rate) {
        if (this.forceListenersToFail) {
            return false;
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
        return true;
    }

    @Implementation
    protected void unregisterListener(SensorEventListener listener, Sensor sensor) {
        this.listeners.remove(listener);
    }

    @Implementation
    protected void unregisterListener(SensorEventListener listener) {
        this.listeners.remove(listener);
    }

    public boolean hasListener(SensorEventListener listener) {
        return this.listeners.contains(listener);
    }

    public List<SensorEventListener> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public void sendSensorEventToListeners(SensorEvent event) {
        for (SensorEventListener listener : this.listeners) {
            listener.onSensorChanged(event);
        }
    }

    public SensorEvent createSensorEvent() {
        return (SensorEvent)ReflectionHelpers.callConstructor(SensorEvent.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    public static SensorEvent createSensorEvent(int valueArraySize) {
        Preconditions.checkArgument((valueArraySize > 0 ? 1 : 0) != 0);
        ReflectionHelpers.ClassParameter valueArraySizeParam = new ReflectionHelpers.ClassParameter(Integer.TYPE, (Object)valueArraySize);
        return (SensorEvent)ReflectionHelpers.callConstructor(SensorEvent.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{valueArraySizeParam});
    }

    @Implementation(minSdk=26)
    protected Object createDirectChannel(MemoryFile mem) {
        return ReflectionHelpers.callConstructor(SensorDirectChannel.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(SensorManager.class, (Object)this.realObject), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)1), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)mem.length())});
    }
}

