/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.util.Log;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(value=Log.class)
public class ShadowLog {
    private static final int extraLogLength = "l/: \n".length();
    private static final Map<String, Queue<LogItem>> logsByTag = Collections.synchronizedMap(new HashMap());
    private static final Queue<LogItem> logs = new ConcurrentLinkedQueue<LogItem>();
    public static PrintStream stream;
    private static final Map<String, Integer> tagToLevel;
    private static boolean wtfIsFatal;

    @Implementation
    protected static int e(String tag, String msg) {
        return ShadowLog.e(tag, msg, null);
    }

    @Implementation
    protected static int e(String tag, String msg, Throwable throwable) {
        return ShadowLog.addLog(6, tag, msg, throwable);
    }

    @Implementation
    protected static int d(String tag, String msg) {
        return ShadowLog.d(tag, msg, null);
    }

    @Implementation
    protected static int d(String tag, String msg, Throwable throwable) {
        return ShadowLog.addLog(3, tag, msg, throwable);
    }

    @Implementation
    protected static int i(String tag, String msg) {
        return ShadowLog.i(tag, msg, null);
    }

    @Implementation
    protected static int i(String tag, String msg, Throwable throwable) {
        return ShadowLog.addLog(4, tag, msg, throwable);
    }

    @Implementation
    protected static int v(String tag, String msg) {
        return ShadowLog.v(tag, msg, null);
    }

    @Implementation
    protected static int v(String tag, String msg, Throwable throwable) {
        return ShadowLog.addLog(2, tag, msg, throwable);
    }

    @Implementation
    protected static int w(String tag, String msg) {
        return ShadowLog.w(tag, msg, null);
    }

    @Implementation
    protected static int w(String tag, Throwable throwable) {
        return ShadowLog.w(tag, null, throwable);
    }

    @Implementation
    protected static int w(String tag, String msg, Throwable throwable) {
        return ShadowLog.addLog(5, tag, msg, throwable);
    }

    @Implementation
    protected static int wtf(String tag, String msg) {
        return ShadowLog.wtf(tag, msg, null);
    }

    @Implementation
    protected static int wtf(String tag, String msg, Throwable throwable) {
        ShadowLog.addLog(7, tag, msg, throwable);
        if (wtfIsFatal) {
            throw new TerribleFailure(msg, throwable);
        }
        return 0;
    }

    public static void setWtfIsFatal(boolean fatal) {
        wtfIsFatal = fatal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected static boolean isLoggable(String tag, int level) {
        Map<String, Integer> map = tagToLevel;
        synchronized (map) {
            if (tagToLevel.containsKey(tag)) {
                return level >= tagToLevel.get(tag);
            }
        }
        return stream != null || level >= 4;
    }

    @Implementation
    protected static int println_native(int bufID, int priority, String tag, String msg) {
        ShadowLog.addLog(priority, tag, msg, null);
        int tagLength = tag == null ? 0 : tag.length();
        int msgLength = msg == null ? 0 : msg.length();
        return extraLogLength + tagLength + msgLength;
    }

    public static void setLoggable(String tag, int level) {
        tagToLevel.put(tag, level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int addLog(int level, String tag, String msg, Throwable throwable) {
        Queue<Object> itemList;
        if (stream != null) {
            ShadowLog.logToStream(stream, level, tag, msg, throwable);
        }
        LogItem item = new LogItem(level, tag, msg, throwable);
        Map<String, Queue<LogItem>> map = logsByTag;
        synchronized (map) {
            if (!logsByTag.containsKey(tag)) {
                itemList = new ConcurrentLinkedQueue();
                logsByTag.put(tag, itemList);
            } else {
                itemList = logsByTag.get(tag);
            }
        }
        itemList.add(item);
        logs.add(item);
        return 0;
    }

    private static void logToStream(PrintStream ps, int level, String tag, String msg, Throwable throwable) {
        char c;
        switch (level) {
            case 7: {
                c = 'A';
                break;
            }
            case 3: {
                c = 'D';
                break;
            }
            case 6: {
                c = 'E';
                break;
            }
            case 5: {
                c = 'W';
                break;
            }
            case 4: {
                c = 'I';
                break;
            }
            case 2: {
                c = 'V';
                break;
            }
            default: {
                c = '?';
            }
        }
        ps.println(c + "/" + tag + ": " + msg);
        if (throwable != null) {
            throwable.printStackTrace(ps);
        }
    }

    public static List<LogItem> getLogs() {
        return new ArrayList<LogItem>(logs);
    }

    public static List<LogItem> getLogsForTag(String tag) {
        Queue<LogItem> logs = logsByTag.get(tag);
        return logs == null ? Collections.emptyList() : new ArrayList<LogItem>(logs);
    }

    public static void clear() {
        ShadowLog.reset();
    }

    @Resetter
    public static void reset() {
        logs.clear();
        logsByTag.clear();
        tagToLevel.clear();
        wtfIsFatal = false;
    }

    public static void setupLogging() {
        String logging = System.getProperty("robolectric.logging");
        if (logging != null && stream == null) {
            PrintStream stream = null;
            if ("stdout".equalsIgnoreCase(logging)) {
                stream = System.out;
            } else if ("stderr".equalsIgnoreCase(logging)) {
                stream = System.err;
            } else {
                try {
                    PrintStream file;
                    stream = file = new PrintStream(new FileOutputStream(logging), true);
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        @Override
                        public void run() {
                            try {
                                file.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ShadowLog.stream = stream;
        }
    }

    static {
        tagToLevel = Collections.synchronizedMap(new HashMap());
        wtfIsFatal = false;
    }

    public static class TerribleFailure
    extends RuntimeException {
        public TerribleFailure(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    public static class LogItem {
        public final int type;
        public final String tag;
        public final String msg;
        public final Throwable throwable;

        public LogItem(int type, String tag, String msg, Throwable throwable) {
            this.type = type;
            this.tag = tag;
            this.msg = msg;
            this.throwable = throwable;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LogItem log = (LogItem)o;
            return !(this.type != log.type || (this.msg == null ? log.msg != null : !this.msg.equals(log.msg)) || (this.tag == null ? log.tag != null : !this.tag.equals(log.tag)) || (this.throwable == null ? log.throwable != null : !this.throwable.equals(log.throwable)));
        }

        public int hashCode() {
            int result = this.type;
            result = 31 * result + (this.tag != null ? this.tag.hashCode() : 0);
            result = 31 * result + (this.msg != null ? this.msg.hashCode() : 0);
            result = 31 * result + (this.throwable != null ? this.throwable.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "LogItem{type=" + this.type + ", tag='" + this.tag + '\'' + ", msg='" + this.msg + '\'' + ", throwable=" + this.throwable + '}';
        }
    }
}

