/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Handler;
import android.os.Message;
import android.os.MessageQueue;
import java.util.ArrayList;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowLegacyMessage;
import org.robolectric.shadows.ShadowMessageQueue;
import org.robolectric.util.Logger;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.Scheduler;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=MessageQueue.class, isInAndroidSdk=false)
public class ShadowLegacyMessageQueue
extends ShadowMessageQueue {
    @RealObject
    private MessageQueue realQueue;
    private Scheduler scheduler;

    @HiddenApi
    @Implementation
    public static Number nativeInit() {
        return 1;
    }

    @HiddenApi
    @Implementation(minSdk=18, maxSdk=20)
    public static void nativeDestroy(int ptr) {
        ShadowLegacyMessageQueue.nativeDestroy((long)ptr);
    }

    @Implementation(minSdk=21)
    protected static void nativeDestroy(long ptr) {
    }

    @HiddenApi
    @Implementation(minSdk=19, maxSdk=20)
    public static boolean nativeIsIdling(int ptr) {
        return ShadowLegacyMessageQueue.nativeIsIdling((long)ptr);
    }

    @Implementation(minSdk=21, maxSdk=22)
    protected static boolean nativeIsIdling(long ptr) {
        return false;
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public Message getHead() {
        return (Message)ReflectionHelpers.getField((Object)this.realQueue, (String)"mMessages");
    }

    @Override
    public void setHead(Message msg) {
        ((_MessageQueue_)Reflector.reflector(_MessageQueue_.class, (Object)this.realQueue)).setMessages(msg);
    }

    @Override
    public void reset() {
        this.setHead(null);
        ReflectionHelpers.setField((Object)this.realQueue, (String)"mIdleHandlers", new ArrayList());
        ReflectionHelpers.setField((Object)this.realQueue, (String)"mNextBarrierToken", (Object)0);
    }

    @Implementation
    protected boolean enqueueMessage(final Message msg, long when) {
        boolean retval = (Boolean)Shadow.directlyOn((Object)this.realQueue, MessageQueue.class, (String)"enqueueMessage", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Message.class, (Object)msg), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)when)});
        if (retval) {
            Runnable callback = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    MessageQueue messageQueue = ShadowLegacyMessageQueue.this.realQueue;
                    synchronized (messageQueue) {
                        Message m = ShadowLegacyMessageQueue.this.getHead();
                        if (m == null) {
                            return;
                        }
                        Message n = ShadowLegacyMessageQueue.shadowOf(m).getNext();
                        if (m == msg) {
                            ShadowLegacyMessageQueue.this.setHead(n);
                        } else {
                            while (n != null) {
                                if (n == msg) {
                                    n = ShadowLegacyMessageQueue.shadowOf(n).getNext();
                                    ShadowLegacyMessageQueue.shadowOf(m).setNext(n);
                                    break;
                                }
                                m = n;
                                n = ShadowLegacyMessageQueue.shadowOf(m).getNext();
                            }
                        }
                    }
                    ShadowLegacyMessageQueue.dispatchMessage(msg);
                }
            };
            ShadowLegacyMessageQueue.shadowOf(msg).setScheduledRunnable(callback);
            if (when == 0L) {
                this.scheduler.postAtFrontOfQueue(callback);
            } else {
                this.scheduler.postDelayed(callback, when - this.scheduler.getCurrentTime());
            }
        }
        return retval;
    }

    private static void dispatchMessage(Message msg) {
        Handler target = msg.getTarget();
        ShadowLegacyMessageQueue.shadowOf(msg).setNext(null);
        if (target != null) {
            ShadowLegacyMessage._Message_ msgProxy = (ShadowLegacyMessage._Message_)Reflector.reflector(ShadowLegacyMessage._Message_.class, (Object)msg);
            msgProxy.markInUse();
            target.dispatchMessage(msg);
            if (RuntimeEnvironment.getApiLevel() >= 21) {
                msgProxy.recycleUnchecked();
            } else {
                msgProxy.recycle();
            }
        }
    }

    @Implementation
    @HiddenApi
    protected void removeSyncBarrier(int token) {
        try {
            Shadow.directlyOn((Object)this.realQueue, MessageQueue.class, (String)"removeSyncBarrier", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)token)});
        }
        catch (IllegalStateException e) {
            Logger.warn((String)"removeSyncBarrier failed! Could not find token %d", (Object[])new Object[]{token});
        }
    }

    private static ShadowLegacyMessage shadowOf(Message actual) {
        return (ShadowLegacyMessage)Shadow.extract((Object)actual);
    }

    @ForType(value=MessageQueue.class)
    static interface _MessageQueue_ {
        @Accessor(value="mMessages")
        public void setMessages(Message var1);
    }
}

