/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=CameraManager.class, minSdk=21)
public class ShadowCameraManager {
    private final Map<String, CameraCharacteristics> cameraIdToCharacteristics = new LinkedHashMap<String, CameraCharacteristics>();
    private final Map<String, Boolean> cameraTorches = new HashMap<String, Boolean>();

    @Implementation
    protected String[] getCameraIdList() throws CameraAccessException {
        Set<String> cameraIds = this.cameraIdToCharacteristics.keySet();
        return cameraIds.toArray(new String[0]);
    }

    @Implementation
    protected CameraCharacteristics getCameraCharacteristics(String cameraId) {
        Preconditions.checkNotNull((Object)cameraId);
        CameraCharacteristics characteristics = this.cameraIdToCharacteristics.get(cameraId);
        Preconditions.checkArgument((characteristics != null ? 1 : 0) != 0);
        return characteristics;
    }

    @Implementation(minSdk=23)
    protected void setTorchMode(String cameraId, boolean enabled) {
        Preconditions.checkNotNull((Object)cameraId);
        Preconditions.checkArgument((boolean)this.cameraIdToCharacteristics.keySet().contains(cameraId));
        this.cameraTorches.put(cameraId, enabled);
    }

    public void addCamera(String cameraId, CameraCharacteristics characteristics) {
        Preconditions.checkNotNull((Object)cameraId);
        Preconditions.checkNotNull((Object)characteristics);
        Preconditions.checkArgument((!this.cameraIdToCharacteristics.containsKey(cameraId) ? 1 : 0) != 0);
        this.cameraIdToCharacteristics.put(cameraId, characteristics);
    }

    public boolean getTorchMode(String cameraId) {
        Preconditions.checkNotNull((Object)cameraId);
        Preconditions.checkArgument((boolean)this.cameraIdToCharacteristics.keySet().contains(cameraId));
        Boolean torchState = this.cameraTorches.get(cameraId);
        return torchState;
    }
}

